/*
 * Decompiled with CFR 0.152.
 */
package de.awolfynight.simplevoicedistance;

import de.awolfynight.simplevoicedistance.config.ClientConfig;
import de.awolfynight.simplevoicedistance.config.ServerConfig;
import de.awolfynight.simplevoicedistance.events.ClientEvents;
import de.awolfynight.simplevoicedistance.network.ChangeModePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="simplevoicedistance")
public class Simplevoicedistance {
    public static final String MODID = "simplevoicedistance";
    private static final String PROTOCOL_VERSION = "1";
    public static final Logger LOGGER = LogManager.getLogger(Simplevoicedistance.class);
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("simplevoicedistance", "network"), () -> "1", "1"::equals, "1"::equals);

    public Simplevoicedistance() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setupCommon);
        bus.addListener(this::setupClient);
        bus.addListener(this::onLoadComplete);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_SPEC, "simplevoicedistance/client.toml");
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        LOGGER.info("=== SimpleVoiceDistance Startup Complete ===");
        this.checkClass("de.awolfynight.simplevoicedistance.network.ChangeModePacket");
        this.checkClass("de.awolfynight.simplevoicedistance.events.ClientEvents");
        this.checkClass("de.awolfynight.simplevoicedistance.voicemanager.VoiceDistanceData");
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        int id = 0;
        CHANNEL.registerMessage(id++, ChangeModePacket.class, ChangeModePacket::encode, ChangeModePacket::decode, ChangeModePacket::handle);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SERVER_SPEC);
        LOGGER.info("Registered network channel for SimpleVoiceDistance");
    }

    private void setupClient(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ClientEvents.class);
        LOGGER.info("Registered client event handlers for SimpleVoiceDistance");
    }

    private void checkClass(String className) {
        try {
            Class.forName(className);
            LOGGER.info("\u2714 Klasse geladen: {}", (Object)className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("\u2718 Klasse NICHT gefunden: {}", (Object)className);
        }
    }
}

