/*
 * Decompiled with CFR 0.152.
 */
package de.awolfynight.simplevoicedistance.events;

import de.awolfynight.simplevoicedistance.config.ServerConfig;
import de.awolfynight.simplevoicedistance.keymapping.KeyBindings;
import de.awolfynight.simplevoicedistance.voicemanager.VoiceDistanceManager;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="simplevoicedistance", value={Dist.CLIENT})
public class ClientEvents {
    private static int cooldownTicksLeft = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || event.phase != TickEvent.Phase.END) {
            return;
        }
        if (cooldownTicksLeft > 0) {
            --cooldownTicksLeft;
        }
        int cooldownSeconds = (Integer)ServerConfig.SERVER.cooldownSeconds.get();
        int cooldownTicks = cooldownSeconds * 20;
        if (KeyBindings.CYCLE.m_90859_() && cooldownTicksLeft == 0) {
            VoiceDistanceManager.cycleMode();
            cooldownTicksLeft = cooldownTicks;
        }
        VoiceDistanceManager.tickParticles();
    }

    private static String getModVersion() {
        return ModList.get().getModContainerById("simplevoicedistance").map(cont -> cont.getModInfo().getVersion().toString()).orElse("?");
    }

    @SubscribeEvent
    public static void onClientLoggedIn(ClientPlayerNetworkEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        String modName = "Simple Voice Distance";
        String version = ClientEvents.getModVersion();
        String author = "awolfynight";
        MutableComponent welcome = Component.m_237110_((String)"message.simplevoicedistance.welcome_simple", (Object[])new Object[]{modName, version, author});
        MutableComponent feedback = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"message.simplevoicedistance.feedback").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0x55FFFF)).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/awolfynight/SimpleVoiceDistance-Issues/issues"))));
        mc.f_91074_.m_5661_((Component)welcome.m_7220_((Component)feedback), false);
    }
}

