/*
 * Decompiled with CFR 0.152.
 */
package de.awolfynight.simplevoicedistance.voicemanager;

import de.awolfynight.simplevoicedistance.voicemanager.VoiceDistanceManager;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.events.EntitySoundPacketEvent;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.LocationalSoundPacketEvent;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

@ForgeVoicechatPlugin
public class VoiceDistanceData
implements VoicechatPlugin {
    private static final Map<UUID, VoiceDistanceManager.Mode> playerModes = new ConcurrentHashMap<UUID, VoiceDistanceManager.Mode>();

    public static void setMode(UUID playerId, VoiceDistanceManager.Mode mode) {
        playerModes.put(playerId, mode);
    }

    public static VoiceDistanceManager.Mode getMode(UUID playerId) {
        return playerModes.getOrDefault(playerId, VoiceDistanceManager.Mode.NORMAL);
    }

    public String getPluginId() {
        return "simplevoicedistance";
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(EntitySoundPacketEvent.class, event -> {
            if (event.getSenderConnection() == null || event.getReceiverConnection() == null) {
                return;
            }
            ServerPlayer sender = event.getSenderConnection().getPlayer();
            ServerPlayer receiver = event.getReceiverConnection().getPlayer();
            if (sender == null || receiver == null) {
                return;
            }
            float maxDistance = VoiceDistanceData.getMode(sender.getUuid()).getDistance();
            double distance = this.distanceBetween(sender, receiver);
            if (distance > (double)maxDistance) {
                event.cancel();
            }
        });
        registration.registerEvent(LocationalSoundPacketEvent.class, event -> {
            if (event.getSenderConnection() == null || event.getReceiverConnection() == null) {
                return;
            }
            ServerPlayer sender = event.getSenderConnection().getPlayer();
            ServerPlayer receiver = event.getReceiverConnection().getPlayer();
            if (sender == null || receiver == null) {
                return;
            }
            float maxDistance = VoiceDistanceData.getMode(sender.getUuid()).getDistance();
            double distance = this.distanceBetween(sender, receiver);
            if (distance > (double)maxDistance) {
                event.cancel();
            }
        });
    }

    private double distanceBetween(ServerPlayer a, ServerPlayer b) {
        double dx = a.getPosition().getX() - b.getPosition().getX();
        double dy = a.getPosition().getY() - b.getPosition().getY();
        double dz = a.getPosition().getZ() - b.getPosition().getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

