/*
 * Decompiled with CFR 0.152.
 */
package gaia.libraries.linbus.tree;

import gaia.libraries.linbus.stream.LinStream;
import gaia.libraries.linbus.stream.token.LinToken;
import gaia.libraries.linbus.tree.LinTag;
import gaia.libraries.linbus.tree.LinTagType;
import java.util.Objects;

public final class LinStringTag
extends LinTag<String> {
    private final String value;

    public static LinStringTag of(String value) {
        return new LinStringTag(value);
    }

    private LinStringTag(String value) {
        this.value = Objects.requireNonNull(value, "value is null");
    }

    @Override
    public LinTagType<LinStringTag> type() {
        return LinTagType.stringTag();
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public LinStream linStream() {
        return LinStream.of((LinToken)new LinToken.String(this.value));
    }
}

