/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.api.arena;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.arena.ArenaImpl;
import me.moros.gaia.api.arena.Point;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.arena.region.Region;
import me.moros.gaia.api.chunk.ChunkPosition;
import me.moros.gaia.api.util.TextUtil;
import net.kyori.adventure.key.Key;

public final class Builder {
    private String name;
    private Key level;
    private Region region;
    private List<ChunkRegion.Validated> chunkRegions;
    private List<Point> points;

    Builder() {
    }

    public Builder name(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    public Builder level(Key level) {
        this.level = Objects.requireNonNull(level);
        return this;
    }

    public Builder region(Region region) {
        this.region = Objects.requireNonNull(region);
        return this;
    }

    public Builder chunks(Collection<ChunkRegion.Validated> chunkRegions) {
        this.chunkRegions = new ArrayList<ChunkRegion.Validated>(chunkRegions);
        return this;
    }

    public Builder points(List<Point> points) {
        this.points = Objects.requireNonNull(points);
        return this;
    }

    private void validate() {
        Objects.requireNonNull(this.name);
        Objects.requireNonNull(this.level);
        Objects.requireNonNull(this.region);
        if (!TextUtil.validateInput(this.name)) {
            throw new IllegalArgumentException(String.format("Arena name %s contains illegal characters!", this.name));
        }
        for (ChunkRegion.Validated chunk : this.chunkRegions) {
            if (this.region.contains(chunk.region().min()) && this.region.contains(chunk.region().max())) continue;
            throw new IllegalArgumentException("Arena region does not contain chunk!");
        }
    }

    public Arena build() {
        this.validate();
        this.chunkRegions.sort(ChunkPosition.ZX_ORDER);
        ArenaImpl arena = new ArenaImpl(this.name, this.level, this.region, this.chunkRegions);
        if (this.points != null) {
            arena.addPoints(this.points);
        }
        return arena;
    }
}

