/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.api.arena.region;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.arena.region.Region;

record ChunkRegionImpl(int x, int z, Region region) implements ChunkRegion
{

    record Validated(ChunkRegion chunk, long checksum, AtomicBoolean revert, AtomicLong lastRevert) implements ChunkRegion.Validated
    {
        public Validated(ChunkRegion chunk, long checksum) {
            this(chunk, checksum, new AtomicBoolean(), new AtomicLong());
        }

        @Override
        public boolean reverting() {
            return this.revert().get();
        }

        @Override
        public void reverting(boolean value) {
            this.revert().set(value);
        }

        @Override
        public long lastReverted() {
            return this.lastRevert().get();
        }

        @Override
        public void resetLastReverted() {
            this.lastRevert().set(System.currentTimeMillis());
        }

        @Override
        public int x() {
            return this.chunk().x();
        }

        @Override
        public int z() {
            return this.chunk().z();
        }

        @Override
        public Region region() {
            return this.chunk().region();
        }

        @Override
        public String toString() {
            return this.chunk().toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Validated) {
                Validated other = (Validated)obj;
                return this.region().equals(other.region()) && this.checksum() == other.checksum();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 31 * this.region().hashCode() + Long.hashCode(this.checksum());
        }
    }
}

