/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common;

import java.util.concurrent.Executors;
import me.moros.gaia.api.Gaia;
import me.moros.gaia.api.event.EventBus;
import me.moros.gaia.api.service.ArenaService;
import me.moros.gaia.api.service.LevelService;
import me.moros.gaia.api.service.OperationService;
import me.moros.gaia.api.service.SelectionService;
import me.moros.gaia.api.service.UserService;
import me.moros.gaia.api.storage.Storage;
import me.moros.gaia.api.util.PluginInfo;
import me.moros.gaia.common.AbstractGaia;
import me.moros.gaia.common.GaiaFactory;
import me.moros.gaia.common.event.EventBusImpl;
import me.moros.gaia.common.service.ArenaServiceImpl;
import me.moros.gaia.common.service.OperationServiceImpl;
import me.moros.gaia.common.service.RevertListener;
import me.moros.gaia.common.storage.FileStorage;
import me.moros.tasker.executor.CompositeExecutor;
import me.moros.tasker.executor.SimpleAsyncExecutor;
import me.moros.tasker.executor.SyncExecutor;

final class GaiaImpl
implements Gaia {
    private final PluginInfo info;
    private final CompositeExecutor executor;
    private final Storage storage;
    private final EventBus eventBus;
    private final UserService userService;
    private final SelectionService selectionService;
    private final LevelService levelService;
    private final OperationService operationService;
    private final ArenaService arenaService;

    GaiaImpl(AbstractGaia<?> plugin, GaiaFactory factory) {
        this.info = factory.build(PluginInfo.class);
        this.executor = CompositeExecutor.of(factory.build(SyncExecutor.class), new SimpleAsyncExecutor(Executors.newVirtualThreadPerTaskExecutor()));
        this.storage = FileStorage.createInstance(this.executor.async(), plugin.logger(), plugin.path());
        this.eventBus = new EventBusImpl(plugin.logger());
        this.userService = factory.build(UserService.class);
        this.selectionService = factory.build(SelectionService.class);
        this.levelService = factory.build(LevelService.class);
        this.operationService = new OperationServiceImpl(this, this.executor.sync());
        this.arenaService = new ArenaServiceImpl(this);
        new RevertListener(this);
    }

    @Override
    public Storage storage() {
        return this.storage;
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public UserService userService() {
        return this.userService;
    }

    @Override
    public SelectionService selectionService() {
        return this.selectionService;
    }

    @Override
    public LevelService levelService() {
        return this.levelService;
    }

    @Override
    public OperationService operationService() {
        return this.operationService;
    }

    @Override
    public ArenaService arenaService() {
        return this.arenaService;
    }

    @Override
    public PluginInfo pluginInfo() {
        return this.info;
    }

    void shutdown() {
        this.operationService.shutdown();
        this.eventBus.shutdown();
        this.executor.shutdown();
    }
}

