/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.command;

import gaia.libraries.cloud.permission.Permission;
import java.util.stream.Stream;

public final class CommandPermissions {
    public static final Permission HELP = CommandPermissions.create("help");
    public static final Permission LIST = CommandPermissions.create("list");
    public static final Permission INFO = CommandPermissions.create("info");
    public static final Permission VERSION = CommandPermissions.create("version");
    public static final Permission CREATE = CommandPermissions.create("create");
    public static final Permission REMOVE = CommandPermissions.create("remove");
    public static final Permission REVERT = CommandPermissions.create("revert");
    public static final Permission BYPASS = CommandPermissions.create("bypass");
    public static final Permission POINT = CommandPermissions.create("point");
    public static final Permission TELEPORT = CommandPermissions.create("teleport");

    private CommandPermissions() {
    }

    private static Permission create(String node) {
        return Permission.of("gaia.command." + node);
    }

    public static Stream<Permission> adminOnly() {
        return Stream.of(HELP, LIST, INFO, VERSION, CREATE, REMOVE, REVERT, BYPASS, POINT, TELEPORT);
    }
}

