/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.command.parser;

import gaia.libraries.cloud.context.CommandContext;
import gaia.libraries.cloud.context.CommandInput;
import gaia.libraries.cloud.parser.ArgumentParseResult;
import gaia.libraries.cloud.parser.ArgumentParser;
import gaia.libraries.cloud.parser.ParserDescriptor;
import gaia.libraries.cloud.suggestion.BlockingSuggestionProvider;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.api.util.TextUtil;
import me.moros.math.Vector3i;
import net.kyori.adventure.key.Key;

public final class ArenaParser
implements ArgumentParser<GaiaUser, Arena>,
BlockingSuggestionProvider.Strings<GaiaUser> {
    private ArenaParser() {
    }

    @Override
    public ArgumentParseResult<Arena> parse(CommandContext<GaiaUser> commandContext, CommandInput commandInput) {
        Arena result;
        String input = TextUtil.sanitizeInput(commandInput.peekString());
        GaiaUser user = commandContext.sender();
        if (input.equalsIgnoreCase("cur")) {
            Vector3i pos = user.position().toVector3i();
            result = user.level().flatMap((? super T levelKey) -> user.parent().arenaService().arena((Key)levelKey, pos)).orElse(null);
        } else {
            result = user.parent().arenaService().arena(input).orElse(null);
        }
        if (result != null) {
            commandInput.readString();
            return ArgumentParseResult.success(result);
        }
        return ArgumentParseResult.failure(new Throwable("Could not find the specified arena"));
    }

    @Override
    public Iterable<String> stringSuggestions(CommandContext<GaiaUser> commandContext, CommandInput commandInput) {
        return commandContext.sender().parent().arenaService().stream().map(Arena::name).sorted().toList();
    }

    public static ParserDescriptor<GaiaUser, Arena> parser() {
        return ParserDescriptor.of(new ArenaParser(), Arena.class);
    }
}

