/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.command.parser;

import gaia.libraries.cloud.context.CommandContext;
import gaia.libraries.cloud.context.CommandInput;
import gaia.libraries.cloud.parser.ArgumentParseResult;
import gaia.libraries.cloud.parser.ArgumentParser;
import gaia.libraries.cloud.parser.ParserDescriptor;
import gaia.libraries.cloud.suggestion.BlockingSuggestionProvider;
import me.moros.gaia.api.platform.GaiaUser;

public final class GaiaUserParser
implements ArgumentParser<GaiaUser, GaiaUser>,
BlockingSuggestionProvider.Strings<GaiaUser> {
    private GaiaUserParser() {
    }

    @Override
    public ArgumentParseResult<GaiaUser> parse(CommandContext<GaiaUser> commandContext, CommandInput commandInput) {
        String input = commandInput.peekString();
        GaiaUser user = input.equalsIgnoreCase("me") ? commandContext.sender() : commandContext.sender().parent().userService().findUser(input);
        if (user != null) {
            commandInput.readString();
            return ArgumentParseResult.success(user);
        }
        return ArgumentParseResult.failure(new Throwable("Could not find the specified user"));
    }

    @Override
    public Iterable<String> stringSuggestions(CommandContext<GaiaUser> commandContext, CommandInput commandInput) {
        return commandContext.sender().parent().userService().users().toList();
    }

    public static ParserDescriptor<GaiaUser, GaiaUser> parser() {
        return ParserDescriptor.of(new GaiaUserParser(), GaiaUser.class);
    }
}

