/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.platform;

import java.util.concurrent.CompletableFuture;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.chunk.Snapshot;
import me.moros.gaia.api.platform.Level;
import me.moros.gaia.api.util.ChunkUtil;
import me.moros.gaia.common.platform.GaiaSnapshot;
import me.moros.gaia.common.platform.VanillaSnapshot;
import me.moros.gaia.common.util.IndexedIterator;
import me.moros.math.Vector3i;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public abstract class VanillaLevel
implements Level {
    private static final TicketType GAIA_TICKET_TYPE = new TicketType(0L, false, TicketType.TicketUse.LOADING);
    private static final int GAIA_TICKET_LEVEL = ChunkLevel.byStatus((ChunkStatus)ChunkStatus.FULL);
    private final ServerLevel handle;

    protected VanillaLevel(ServerLevel handle) {
        this.handle = handle;
    }

    protected ServerLevel handle() {
        return this.handle;
    }

    @Override
    public CompletableFuture<Boolean> restoreSnapshot(Snapshot snapshot, int amount) {
        if (amount > 0 && snapshot instanceof GaiaSnapshot) {
            GaiaSnapshot gaiaSnapshot = (GaiaSnapshot)snapshot;
            return this.loadChunkAsync(snapshot.x(), snapshot.z()).thenApply(c -> this.restoreSnapshotNow(gaiaSnapshot, amount));
        }
        return CompletableFuture.completedFuture(false);
    }

    private boolean restoreSnapshotNow(GaiaSnapshot snapshot, int amount) {
        ServerChunkCache chunkSource = this.chunkSource();
        LevelChunk levelChunk = chunkSource.getChunkNow(snapshot.x(), snapshot.z());
        if (levelChunk == null) {
            return false;
        }
        Vector3i offset = ChunkUtil.toChunkSectionPos(snapshot.chunk().region().min());
        int xOffset = offset.blockX();
        int yOffset = offset.blockY();
        int zOffset = offset.blockZ();
        IndexedIterator<BlockState> it = snapshot.iterator();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int counter = 0;
        while (it.hasNext() && ++counter <= amount) {
            BlockState result;
            int index = it.index();
            BlockState toRestore = it.next();
            int y = yOffset + index / 256;
            int z = zOffset + index % 256 / 16;
            int x = xOffset + index % 256 % 16;
            if (!snapshot.chunk().region().contains(x, y, z) || (result = levelChunk.setBlockState((BlockPos)mutablePos.set(x, y, z), toRestore, 512)) == null || result == toRestore) continue;
            chunkSource.blockChanged((BlockPos)mutablePos);
        }
        return it.hasNext();
    }

    @Override
    public CompletableFuture<Snapshot> snapshot(ChunkRegion chunk) {
        return this.loadChunkAsync(chunk.x(), chunk.z()).thenApply(c -> VanillaSnapshot.from(chunk, c));
    }

    @Override
    public CompletableFuture<?> loadChunkWithTicket(int x, int z) {
        return this.loadChunkAsync(x, z).thenAccept(c -> this.addChunkTicket(x, z));
    }

    protected CompletableFuture<ChunkAccess> loadChunkAsync(int x, int z) {
        return this.chunkSource().getChunkFuture(x, z, ChunkStatus.FEATURES, false).thenApply(result -> (ChunkAccess)result.orElseThrow(IllegalStateException::new));
    }

    @Override
    public void addChunkTicket(int x, int z) {
        ChunkPos chunkPos = new ChunkPos(x, z);
        this.chunkSource().addTicket(this.gaiaTicket(), chunkPos);
    }

    protected Ticket gaiaTicket() {
        return new Ticket(GAIA_TICKET_TYPE, GAIA_TICKET_LEVEL);
    }

    protected ServerChunkCache chunkSource() {
        return this.handle().getChunkSource();
    }
}

