/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.platform.codec;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.moros.gaia.api.util.supplier.Suppliers;
import me.moros.gaia.common.platform.codec.SimpleCodec;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BlockStateCodec
implements SimpleCodec<BlockState> {
    static final SimpleCodec<BlockState> INSTANCE = new BlockStateCodec();
    private final int dataVersion = SharedConstants.getCurrentVersion().dataVersion().version();
    private final Logger logger = LoggerFactory.getLogger((String)"Gaia");
    private final Supplier<Map<String, BlockState>> cache = Suppliers.lazy(BlockStateCodec::buildCache);

    private BlockStateCodec() {
    }

    @Override
    public int dataVersion() {
        return this.dataVersion;
    }

    @Override
    public String toString(BlockState value) {
        return BlockStateCodec.convertToString(value);
    }

    @Override
    public @Nullable BlockState fromString(String raw, int srcVersion) {
        BlockState result = this.cache.get().computeIfAbsent(raw, v -> this.calculateBlockState((String)v, srcVersion));
        if (result == null) {
            this.logger.warn("Invalid BlockState: " + raw + ". Block will be replaced with air.");
            return Blocks.AIR.defaultBlockState();
        }
        return result;
    }

    private @Nullable BlockState calculateBlockState(String data, int srcVersion) {
        CompoundTag nbt = this.stateToNBT(data);
        CompoundTag result = (CompoundTag)DataFixers.getDataFixer().update(References.BLOCK_STATE, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbt), srcVersion, this.dataVersion).getValue();
        return this.nbtToState(result);
    }

    private CompoundTag stateToNBT(String blockState) {
        int propIdx = blockState.indexOf(91);
        CompoundTag tag = new CompoundTag();
        if (propIdx < 0) {
            tag.putString("Name", blockState);
        } else {
            String[] propArr;
            tag.putString("Name", blockState.substring(0, propIdx));
            CompoundTag propTag = new CompoundTag();
            String props = blockState.substring(propIdx + 1, blockState.length() - 1);
            for (String pair : propArr = props.split(",")) {
                String[] split = pair.split("=");
                propTag.putString(split[0], split[1]);
            }
            tag.put("Properties", (Tag)propTag);
        }
        return tag;
    }

    private @Nullable BlockState nbtToState(CompoundTag nbt) {
        Block block;
        if (!nbt.contains("Name")) {
            return null;
        }
        ResourceLocation rsl = nbt.getString("Name").map(ResourceLocation::tryParse).orElse(null);
        Block block2 = block = rsl == null ? null : (Block)BuiltInRegistries.BLOCK.getValue(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)rsl));
        if (block == null) {
            return null;
        }
        BlockState blockState = block.defaultBlockState();
        CompoundTag compoundTag = nbt.getCompound("Properties").orElse(null);
        if (compoundTag != null) {
            StateDefinition stateDefinition = block.getStateDefinition();
            for (String propertyName : compoundTag.keySet()) {
                Property property = stateDefinition.getProperty(propertyName);
                if (property == null) continue;
                blockState = BlockStateCodec.trySetValue(blockState, property, propertyName, compoundTag);
            }
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState trySetValue(BlockState state, Property<T> property, String propertyName, CompoundTag compoundTag) {
        return compoundTag.getString(propertyName).flatMap(arg_0 -> property.getValue(arg_0)).map(t -> (BlockState)state.setValue(property, t)).orElse(state);
    }

    private static String propertyMapper(Map.Entry<Property<?>, Comparable<?>> entry) {
        Property<?> property = entry.getKey();
        return property.getName() + "=" + BlockStateCodec.getName(property, entry.getValue());
    }

    private static <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> value) {
        return property.getName(value);
    }

    private static String convertToString(BlockState state) {
        StringBuilder sb = new StringBuilder();
        sb.append(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()));
        if (!state.getValues().isEmpty()) {
            sb.append('[');
            sb.append(state.getValues().entrySet().stream().map(BlockStateCodec::propertyMapper).collect(Collectors.joining(",")));
            sb.append(']');
        }
        return sb.toString();
    }

    private static Map<String, BlockState> buildCache() {
        ConcurrentHashMap<String, BlockState> map = new ConcurrentHashMap<String, BlockState>(Block.BLOCK_STATE_REGISTRY.size());
        Block.BLOCK_STATE_REGISTRY.forEach(state -> map.put(BlockStateCodec.convertToString(state), (BlockState)state));
        return map;
    }
}

