/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.platform.codec;

import gaia.libraries.linbus.tree.LinCompoundTag;
import gaia.libraries.linbus.tree.LinIntTag;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import me.moros.gaia.common.platform.codec.PaletteDecoder;
import me.moros.gaia.common.platform.codec.SimpleCodec;

record PaletteDecoderImpl<R>(SimpleCodec<R> codec) implements PaletteDecoder<R>
{
    @Override
    public Int2ObjectMap<R> apply(LinCompoundTag paletteObject, int srcVersion) throws IOException {
        Set entrySet = paletteObject.value().entrySet();
        Int2ObjectArrayMap palette = new Int2ObjectArrayMap(entrySet.size());
        for (Map.Entry palettePart : entrySet) {
            Object v = palettePart.getValue();
            if (v instanceof LinIntTag) {
                LinIntTag idTag = (LinIntTag)v;
                String raw = (String)palettePart.getKey();
                palette.put(idTag.valueAsInt(), this.codec().fromString(raw, srcVersion));
                continue;
            }
            throw new IOException("Invalid palette entry: " + String.valueOf(palettePart));
        }
        return palette;
    }
}

