/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.service;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import me.moros.gaia.api.Gaia;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.arena.RevertResult;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.operation.GaiaOperation;
import me.moros.gaia.api.platform.Level;
import me.moros.gaia.api.service.ArenaService;
import me.moros.gaia.common.config.ConfigManager;
import me.moros.gaia.common.locale.Message;
import me.moros.gaia.common.util.FutureUtil;
import me.moros.gaia.common.util.ListUtil;

public class ArenaServiceImpl
implements ArenaService {
    private final Gaia plugin;
    private final Map<String, Arena> arenas;

    public ArenaServiceImpl(Gaia plugin) {
        this.plugin = plugin;
        this.arenas = new ConcurrentHashMap<String, Arena>();
    }

    @Override
    public boolean contains(String name) {
        return this.arenas.containsKey(name) || this.plugin.storage().arenaFileExists(name);
    }

    @Override
    public Optional<Arena> arena(String name) {
        return Optional.ofNullable(this.arenas.get(name));
    }

    @Override
    public boolean add(Arena arena) {
        if (this.stream().filter(a -> a.level().equals((Object)arena.level())).map(Arena::region).anyMatch(arena.region()::intersects)) {
            return false;
        }
        return this.arenas.putIfAbsent(arena.name(), arena) == null;
    }

    @Override
    public boolean remove(String name) {
        Level level;
        Arena arena = this.arenas.remove(name);
        if (arena != null && (level = this.plugin.levelService().findLevel(arena.level())) != null) {
            arena.forEach(c -> this.plugin.operationService().cancel(level, (ChunkRegion)c));
        }
        return this.plugin.storage().deleteArena(name);
    }

    @Override
    public int size() {
        return this.arenas.size();
    }

    @Override
    public Stream<Arena> stream() {
        return this.arenas.values().stream();
    }

    @Override
    public Iterator<Arena> iterator() {
        return Collections.unmodifiableCollection(this.arenas.values()).iterator();
    }

    @Override
    public RevertResult revert(Arena arena) {
        Level level = this.plugin.levelService().findLevel(arena.level());
        if (level == null) {
            return RevertResult.fail(Message.REVERT_ERROR_UNLOADED.build(arena.displayName()));
        }
        if (arena.reverting()) {
            return RevertResult.fail(Message.REVERT_ERROR_REVERTING.build(arena.displayName()));
        }
        arena.resetLastReverted();
        long startTime = System.currentTimeMillis();
        List<ChunkRegion.Validated> chunks = arena.chunks();
        for (ChunkRegion.Validated chunk : chunks) {
            level.addChunkTicket(chunk);
            chunk.reverting(true);
        }
        List<CompletableFuture> futures = ListUtil.partition(chunks, 32).stream().map(batch -> this.plugin.storage().loadDataAsync(arena.name(), (Collection<ChunkRegion.Validated>)batch)).toList();
        int sectionsPerTick = ConfigManager.instance().config().sectionsPerTick();
        CompletionStage future = ((CompletableFuture)FutureUtil.createFailFastBatch(futures).thenCompose(batches -> {
            List<CompletableFuture> opFutures = batches.stream().flatMap(Collection::stream).map(data -> GaiaOperation.revert(level, data, sectionsPerTick)).map(this.plugin.operationService()::add).toList();
            return FutureUtil.createFailFast(opFutures);
        })).handle((ignored, throwable) -> {
            boolean completed = throwable != null;
            long result = System.currentTimeMillis() - startTime;
            this.plugin.eventBus().postArenaRevertEvent(arena, result, completed);
            if (throwable != null) {
                throw new CompletionException((Throwable)throwable);
            }
            return result;
        });
        return RevertResult.success(Message.REVERT_SUCCESS.build(arena.displayName()), (CompletableFuture<Long>)future);
    }
}

