/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.service;

import java.util.Collection;
import java.util.List;
import me.moros.gaia.api.Gaia;
import me.moros.gaia.api.chunk.ChunkPosition;
import me.moros.gaia.api.event.ArenaRevertEvent;
import me.moros.gaia.api.event.ChunkRevertEvent;
import me.moros.gaia.api.platform.Level;
import me.moros.gaia.api.util.ChunkUtil;
import me.moros.gaia.api.util.LightFixer;
import me.moros.gaia.common.config.ConfigManager;
import net.kyori.adventure.key.Key;

public final class RevertListener {
    private final Gaia plugin;

    public RevertListener(Gaia plugin) {
        this.plugin = plugin;
        this.registerListeners();
    }

    private void registerListeners() {
        this.plugin.eventBus().subscribe(ArenaRevertEvent.class, this::onArenaRevert);
        this.plugin.eventBus().subscribe(ChunkRevertEvent.class, this::onChunkRevert);
    }

    private void onArenaRevert(ArenaRevertEvent event) {
        if (ConfigManager.instance().config().lightFixer() == LightFixer.POST_ARENA) {
            this.handleRevert(event.arena().level(), ChunkUtil.spiralChunks(event.arena().region()));
        }
    }

    private void onChunkRevert(ChunkRevertEvent event) {
        if (ConfigManager.instance().config().lightFixer() == LightFixer.POST_CHUNK) {
            this.handleRevert(event.level(), List.of(event.chunk()));
        }
    }

    private void handleRevert(Key levelKey, Collection<ChunkPosition> chunks) {
        Level level = this.plugin.levelService().findLevel(levelKey);
        if (level != null) {
            level.fixLight(chunks);
        }
    }
}

