/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.storage;

import gaia.libraries.linbus.stream.LinStream;
import gaia.libraries.linbus.tree.LinCompoundTag;
import gaia.libraries.linbus.tree.LinRootEntry;
import gaia.libraries.linbus.tree.LinTagType;
import java.io.Closeable;
import java.io.IOException;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.chunk.Snapshot;
import me.moros.gaia.common.platform.GaiaSnapshot;
import me.moros.gaia.common.platform.codec.Codecs;

public class SchemReader
implements Closeable {
    private final LinStream rootStream;

    public SchemReader(LinStream rootStream) {
        this.rootStream = rootStream;
    }

    public Snapshot read(ChunkRegion chunkRegion) throws IOException {
        LinCompoundTag schematicTag = this.getBaseTag();
        int schematicVersion = schematicTag.getTag("Version", LinTagType.intTag()).valueAsInt();
        if (schematicVersion != 3) {
            throw new IllegalStateException("Unknown schematic version " + schematicVersion);
        }
        int dataVersion = schematicTag.getTag("DataVersion", LinTagType.intTag()).valueAsInt();
        return this.readVersion3(schematicTag, chunkRegion, dataVersion);
    }

    private LinCompoundTag getBaseTag() throws IOException {
        return LinRootEntry.readFrom(this.rootStream).value().getTag("Schematic", LinTagType.compoundTag());
    }

    private Snapshot readVersion3(LinCompoundTag schematicTag, ChunkRegion chunkRegion, int dataVersion) throws IOException {
        LinCompoundTag blockContainer = schematicTag.getTag("Blocks", LinTagType.compoundTag());
        LinCompoundTag paletteObject = blockContainer.getTag("Palette", LinTagType.compoundTag());
        byte[] blocks = blockContainer.getTag("Data", LinTagType.byteArrayTag()).value();
        return GaiaSnapshot.from(chunkRegion, Codecs.paletteDecoder().apply(paletteObject, dataVersion), blocks);
    }

    @Override
    public void close() throws IOException {
    }
}

