/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class FutureUtil {
    private FutureUtil() {
    }

    public static <T> CompletableFuture<Void> createFailFast(Collection<? extends CompletableFuture<? extends T>> futures) {
        CompletableFuture<Void> allOf = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        for (CompletableFuture<T> completableFuture : futures) {
            FutureUtil.cancel(completableFuture, allOf);
        }
        return allOf;
    }

    public static <T> CompletableFuture<List<T>> createFailFastBatch(Collection<? extends CompletableFuture<? extends T>> futures) {
        return FutureUtil.createFailFast(futures).thenApply(ignored -> {
            ArrayList result = new ArrayList(futures.size());
            futures.forEach(f -> result.add(f.join()));
            return result;
        });
    }

    private static void cancel(CompletableFuture<?> future, CompletableFuture<?> allOf) {
        future.exceptionally(e -> {
            if (!allOf.isDone()) {
                allOf.completeExceptionally((Throwable)e);
            }
            return null;
        });
    }
}

