/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.arena.region.Region;
import me.moros.gaia.api.chunk.Snapshot;
import me.moros.gaia.api.operation.GaiaOperation;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.api.platform.Level;
import me.moros.gaia.api.util.ChunkUtil;
import me.moros.gaia.api.util.TextUtil;
import me.moros.gaia.common.config.ConfigManager;
import me.moros.gaia.common.locale.Message;
import me.moros.gaia.common.util.FutureUtil;
import me.moros.gaia.common.util.ListUtil;
import me.moros.math.Vector3i;
import net.kyori.adventure.audience.Audience;
import org.slf4j.Logger;

public final class UserArenaFactory {
    private final GaiaUser user;
    private final Logger logger;

    public UserArenaFactory(GaiaUser user, Logger logger) {
        this.user = user;
        this.logger = logger;
    }

    public boolean tryCreate(String name) {
        String arenaName = TextUtil.sanitizeInput(name);
        if (arenaName.length() < 3) {
            Message.CREATE_ERROR_VALIDATION.send((Audience)this.user);
            return false;
        }
        if (this.user.parent().arenaService().contains(arenaName)) {
            Message.CREATE_ERROR_EXISTS.send((Audience)this.user, arenaName);
            return false;
        }
        return this.withValidName(arenaName);
    }

    private boolean withValidName(String arenaName) {
        Level level = this.user.level().map(this.user.parent().levelService()::findLevel).orElse(null);
        if (level == null) {
            Message.PLAYER_REQUIRED.send((Audience)this.user);
            return false;
        }
        Region region = this.user.parent().selectionService().selection(this.user).orElse(null);
        if (region == null) {
            Message.CREATE_ERROR_SELECTION.send((Audience)this.user);
            return false;
        }
        double radius = region.size().maxComponent();
        if (radius > 1024.0) {
            Message.CREATE_ERROR_SIZE.send((Audience)this.user);
            return false;
        }
        if (region.center().distanceSq(this.user.position()) > radius * radius) {
            Message.CREATE_ERROR_DISTANCE.send((Audience)this.user);
            return false;
        }
        Arena intersection = this.user.parent().arenaService().arena(level.key(), region).orElse(null);
        if (intersection != null) {
            Message.CREATE_ERROR_INTERSECTION.send((Audience)this.user, intersection.displayName());
            return false;
        }
        this.user.parent().selectionService().resetSelection(this.user);
        return this.withValidSelection(arenaName, level, region);
    }

    private boolean withValidSelection(String arenaName, Level level, Region region) {
        if (!this.user.parent().storage().createEmptyArenaFiles(arenaName)) {
            Message.CREATE_ERROR_CRITICAL.send((Audience)this.user);
            return false;
        }
        Collection<ChunkRegion> chunkRegions = ChunkUtil.splitIntoChunks(region);
        if (chunkRegions.isEmpty()) {
            Message.CREATE_FAIL.send((Audience)this.user, arenaName);
            return false;
        }
        Vector3i size = region.size();
        int optimalChunkAmount = ChunkUtil.toChunkPos(size.blockX()) * ChunkUtil.toChunkPos(size.blockZ());
        int optimalHeight = ChunkUtil.toChunkPos(size.blockY());
        if (chunkRegions.size() > optimalChunkAmount || ChunkUtil.calculateSections(region) % 16 > optimalHeight) {
            Message.CREATE_WARN_CHUNK_ALIGN.send((Audience)this.user);
        }
        Message.CREATE_ANALYZING.send((Audience)this.user, arenaName);
        this.createFuture(arenaName, level, region, chunkRegions);
        return true;
    }

    private void createFuture(String arenaName, Level level, Region region, Collection<ChunkRegion> chunkRegions) {
        List<CompletableFuture> futures = chunkRegions.stream().map(c -> GaiaOperation.snapshotAnalyze(level, c)).map(this.user.parent().operationService()::add).toList();
        long startTime = System.currentTimeMillis();
        AtomicLong deltaTime = new AtomicLong();
        ((CompletableFuture)((CompletableFuture)FutureUtil.createFailFastBatch(futures).orTimeout(ConfigManager.instance().config().timeout(), TimeUnit.MILLISECONDS).thenCompose(data -> FutureUtil.createFailFastBatch(ListUtil.partition(data, 64).stream().map(batch -> this.user.parent().storage().saveDataAsync(arenaName, (Iterable<Snapshot>)batch)).toList()))).thenCompose(validatedBatches -> {
            List<ChunkRegion.Validated> validated = validatedBatches.stream().flatMap(Collection::stream).toList();
            int expected = chunkRegions.size();
            int result = validated.size();
            if (result != expected) {
                return null;
            }
            Arena arena = Arena.builder().name(arenaName).level(level.key()).region(region).chunks(validated).build();
            long dt = System.currentTimeMillis() - startTime;
            deltaTime.set(dt);
            this.user.parent().eventBus().postArenaAnalyzeEvent(arena, dt);
            return this.user.parent().storage().saveArena(arena);
        })).whenComplete((arena, throwable) -> {
            chunkRegions.forEach(level::removeChunkTicket);
            if (arena != null) {
                this.user.parent().arenaService().add((Arena)arena);
                Message.CREATE_SUCCESS.send((Audience)this.user, arena.displayName(), deltaTime.get());
            } else {
                this.user.parent().arenaService().remove(arenaName);
                if (throwable instanceof TimeoutException) {
                    Message.CREATE_FAIL_TIMEOUT.send((Audience)this.user, arenaName);
                } else {
                    Message.CREATE_FAIL.send((Audience)this.user, arenaName);
                    this.logger.error(throwable.getMessage(), throwable);
                }
            }
        });
    }
}

