/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.paper;

import gaia.libraries.bstats.bukkit.Metrics;
import gaia.libraries.cloud.SenderMapper;
import gaia.libraries.cloud.execution.ExecutionCoordinator;
import gaia.libraries.cloud.paper.PaperCommandManager;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import me.moros.gaia.api.Gaia;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.api.service.LevelService;
import me.moros.gaia.api.service.SelectionService;
import me.moros.gaia.api.service.UserService;
import me.moros.gaia.api.util.PluginInfo;
import me.moros.gaia.common.AbstractGaia;
import me.moros.gaia.common.command.CommandPermissions;
import me.moros.gaia.common.command.Commander;
import me.moros.gaia.common.util.PluginInfoContainer;
import me.moros.gaia.paper.GaiaBootstrap;
import me.moros.gaia.paper.platform.BukkitGaiaUser;
import me.moros.gaia.paper.platform.RegionExecutor;
import me.moros.gaia.paper.service.BukkitWorldEditSelectionService;
import me.moros.gaia.paper.service.GaiaSelectionService;
import me.moros.gaia.paper.service.LevelServiceImpl;
import me.moros.gaia.paper.service.UserServiceImpl;
import me.moros.tasker.executor.SyncExecutor;
import me.moros.tasker.paper.PaperExecutor;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.Logger;

public class PaperGaia
extends AbstractGaia<GaiaBootstrap> {
    private Commander commander;

    protected PaperGaia(GaiaBootstrap parent, Path path, Logger logger) {
        super(parent, path, logger);
    }

    void onPluginEnable() {
        new Metrics((Plugin)this.parent, 8608);
        this.factory.bind(PluginInfo.class, this::createInfo).bind(SyncExecutor.class, () -> new PaperExecutor((Plugin)this.parent)).bind(UserService.class, () -> new UserServiceImpl(() -> this.api(), ((GaiaBootstrap)((Object)((Object)this.parent))).getServer())).bind(LevelService.class, () -> new LevelServiceImpl(RegionExecutor.create((Plugin)this.parent), this.logger()));
        this.bindSelectionService();
        this.load();
        PaperCommandManager<GaiaUser> manager = PaperCommandManager.builder(SenderMapper.create(s -> BukkitGaiaUser.from(this.api(), s), u -> (CommandSourceStack)((BukkitGaiaUser)u).handle())).executionCoordinator(ExecutionCoordinator.simpleCoordinator()).buildOnEnable((Plugin)this.parent);
        this.commander = Commander.create(manager, this.api(), this.logger());
        this.initPermissions();
        ((GaiaBootstrap)((Object)this.parent)).getServer().getServicesManager().register(Gaia.class, (Object)this.api(), (Plugin)this.parent, ServicePriority.Normal);
    }

    void onPluginDisable() {
        this.disable();
    }

    private void bindSelectionService() {
        if (((GaiaBootstrap)((Object)this.parent)).getServer().getPluginManager().isPluginEnabled("WorldEdit")) {
            this.factory.bind(SelectionService.class, BukkitWorldEditSelectionService::new);
        } else {
            this.factory.bind(SelectionService.class, () -> new GaiaSelectionService((JavaPlugin)this.parent));
        }
    }

    private void initPermissions() {
        Map<String, Boolean> adminPerms = CommandPermissions.adminOnly().collect(Collectors.toMap(gaia.libraries.cloud.permission.Permission::permissionString, p -> true));
        ((GaiaBootstrap)((Object)this.parent)).getServer().getPluginManager().addPermission(new Permission(CommandPermissions.VERSION.toString(), PermissionDefault.TRUE));
        ((GaiaBootstrap)((Object)this.parent)).getServer().getPluginManager().addPermission(new Permission("gaia.admin", PermissionDefault.OP, adminPerms));
    }

    private PluginInfo createInfo() {
        return new PluginInfoContainer((String)((GaiaBootstrap)((Object)this.parent)).getPluginMeta().getAuthors().get(0), ((GaiaBootstrap)((Object)this.parent)).getPluginMeta().getVersion());
    }
}

