/*
 * Decompiled with CFR 0.152.
 */
package me.moros.math;

import me.moros.math.DoublePoint;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.VectorOperations;
import me.moros.math.adapter.Adapters;

public interface Vector3d
extends VectorOperations<Vector3d> {
    public static final Vector3d ZERO = Vector3d.of(0.0, 0.0, 0.0);
    public static final Vector3d ONE = Vector3d.of(1.0, 1.0, 1.0);
    public static final Vector3d PLUS_I = Vector3d.of(1.0, 0.0, 0.0);
    public static final Vector3d MINUS_I = Vector3d.of(-1.0, 0.0, 0.0);
    public static final Vector3d PLUS_J = Vector3d.of(0.0, 1.0, 0.0);
    public static final Vector3d MINUS_J = Vector3d.of(0.0, -1.0, 0.0);
    public static final Vector3d PLUS_K = Vector3d.of(0.0, 0.0, 1.0);
    public static final Vector3d MINUS_K = Vector3d.of(0.0, 0.0, -1.0);

    @Override
    default public int blockX() {
        return FastMath.floor(this.x());
    }

    @Override
    default public int blockY() {
        return FastMath.floor(this.y());
    }

    @Override
    default public int blockZ() {
        return FastMath.floor(this.z());
    }

    @Override
    default public Vector3d toVector3d() {
        return this;
    }

    @Override
    default public Vector3d add(double dx, double dy, double dz) {
        return Vector3d.of(this.x() + dx, this.y() + dy, this.z() + dz);
    }

    @Override
    default public Vector3d multiply(double ax, double ay, double az) {
        return Vector3d.of(ax * this.x(), ay * this.y(), az * this.z());
    }

    @Override
    default public Vector3d negate() {
        return Vector3d.of(-this.x(), -this.y(), -this.z());
    }

    @Override
    default public Vector3d cross(Position v) {
        double newX = this.y() * v.z() - v.y() * this.z();
        double newY = this.z() * v.x() - v.z() * this.x();
        double newZ = this.x() * v.y() - v.x() * this.y();
        return Vector3d.of(newX, newY, newZ);
    }

    @Override
    default public Vector3d min(Position v) {
        return Vector3d.of(Math.min(this.x(), v.x()), Math.min(this.y(), v.y()), Math.min(this.z(), v.z()));
    }

    @Override
    default public Vector3d max(Position v) {
        return Vector3d.of(Math.max(this.x(), v.x()), Math.max(this.y(), v.y()), Math.max(this.z(), v.z()));
    }

    @Override
    default public Vector3d abs() {
        return Vector3d.of(Math.abs(this.x()), Math.abs(this.y()), Math.abs(this.z()));
    }

    @Override
    default public Vector3d floor() {
        return Vector3d.of(this.blockX(), this.blockY(), this.blockZ());
    }

    @Override
    default public Vector3d clampVelocity() {
        double clampedX = Math.clamp(this.x(), -4.0, 4.0);
        double clampedY = Math.clamp(this.y(), -4.0, 4.0);
        double clampedZ = Math.clamp(this.z(), -4.0, 4.0);
        return Vector3d.of(clampedX, clampedY, clampedZ);
    }

    default public Vector3d normalize() {
        return this.normalize(PLUS_I);
    }

    default public Vector3d normalize(Vector3d def) {
        double s = this.length();
        if (s == 0.0) {
            return def;
        }
        return (Vector3d)this.multiply(1.0 / s);
    }

    default public Adapters<Vector3d> adapters() {
        return Adapters.vector3d();
    }

    public static Vector3d of(double x, double y, double z) {
        return new DoublePoint(x, y, z);
    }

    public static Vector3d from(double[] v) {
        if (v.length != 3) {
            throw new IllegalArgumentException("Expected array length 3 found " + v.length);
        }
        return Vector3d.of(v[0], v[1], v[2]);
    }

    public static <T> Vector3d from(T object) {
        return Adapters.vector3d().adapt(object);
    }
}

