/*
 * Decompiled with CFR 0.152.
 */
package me.moros.tasker;

import java.util.Objects;
import me.moros.tasker.Expiring;
import me.moros.tasker.HierarchicalTimerWheel;
import me.moros.tasker.SimpleTimerWheel;
import me.moros.tasker.TaskList;
import me.moros.tasker.TimerWheel;

abstract sealed class AbstractTimerWheel
implements TimerWheel
permits SimpleTimerWheel, HierarchicalTimerWheel {
    private int currentTick;

    protected AbstractTimerWheel() {
    }

    @Override
    public final int currentTick() {
        return this.currentTick;
    }

    protected final void incrementTick() {
        ++this.currentTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void advance() {
        AbstractTimerWheel abstractTimerWheel = this;
        synchronized (abstractTimerWheel) {
            this.advanceSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown(boolean run) {
        AbstractTimerWheel abstractTimerWheel = this;
        synchronized (abstractTimerWheel) {
            this.shutdownSync(run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T extends Expiring> T schedule(T task, int delay) {
        Objects.requireNonNull(task);
        if (task.repeat() < 0 || delay < 0) {
            throw new IllegalArgumentException();
        }
        AbstractTimerWheel abstractTimerWheel = this;
        synchronized (abstractTimerWheel) {
            this.reschedule(task, delay);
        }
        return task;
    }

    protected final void reschedule(Expiring node, int ticks) {
        TaskList tasks = this.findBucket(ticks);
        node.unlink();
        node.parent = tasks;
        node.expiringTick = this.currentTick + ticks;
        tasks.add(node);
    }

    protected final void expire(TaskList tasks) {
        Expiring node = tasks.unlinkFirst();
        while (node != null) {
            node.run();
            int repeat = node.repeat();
            if (repeat > 0) {
                this.reschedule(node, repeat);
            }
            node = tasks.unlinkFirst();
        }
    }

    protected abstract void advanceSync();

    protected abstract void shutdownSync(boolean var1);

    protected abstract TaskList findBucket(int var1);
}

