/*
 * Decompiled with CFR 0.152.
 */
package me.moros.tasker.executor;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.moros.tasker.Task;
import me.moros.tasker.executor.TaskExecutor;
import org.checkerframework.checker.nullness.qual.PolyNull;

public interface SyncExecutor
extends TaskExecutor {
    @Override
    default public <V> CompletableFuture<@PolyNull V> submit(Supplier<@PolyNull V> task, long delay, TimeUnit unit) {
        return this.submit(task, this.toTicks(delay, unit));
    }

    @Override
    default public Task repeat(Runnable task, int periodTicks) {
        return this.repeat(this.toConsumer(task), 0, periodTicks);
    }

    @Override
    default public Task repeat(Runnable task, int ticks, int periodTicks) {
        return this.repeat(this.toConsumer(task), ticks, periodTicks);
    }

    @Override
    default public Task repeat(Runnable task, long delay, long period, TimeUnit unit) {
        return this.repeat(this.toConsumer(task), delay, period, unit);
    }

    default public Task repeat(Consumer<? super Task> task, int periodTicks) {
        return this.repeat(task, 0, periodTicks);
    }

    default public Task repeat(Consumer<? super Task> task, long period, TimeUnit unit) {
        return this.repeat(task, 0L, period, unit);
    }

    default public Task repeat(Consumer<? super Task> task, long delay, long period, TimeUnit unit) {
        return this.repeat(task, this.toTicks(delay, unit), this.toTicks(period, unit));
    }

    public Task repeat(Consumer<? super Task> var1, int var2, int var3);

    public void clear();

    private Consumer<? super Task> toConsumer(Runnable task) {
        Objects.requireNonNull(task);
        return t -> task.run();
    }
}

