/*
 * Decompiled with CFR 0.152.
 */
package gaia.libraries.cloud.bean;

import gaia.libraries.cloud.Command;
import gaia.libraries.cloud.CommandFactory;
import gaia.libraries.cloud.CommandManager;
import gaia.libraries.cloud.bean.CommandProperties;
import gaia.libraries.cloud.context.CommandContext;
import gaia.libraries.cloud.execution.CommandExecutionHandler;
import gaia.libraries.cloud.meta.CommandMeta;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public abstract class CommandBean<C>
implements CommandExecutionHandler<C>,
CommandFactory<C> {
    protected CommandBean() {
    }

    @Override
    public @NonNull List<@NonNull Command<? extends C>> createCommands(@NonNull CommandManager<C> commandManager) {
        Command.Builder builder = commandManager.commandBuilder(this.properties().name(), this.properties().aliases(), this.meta()).handler(this);
        return Collections.singletonList(this.configure(builder).build());
    }

    protected @NonNull CommandMeta meta() {
        return CommandMeta.builder().build();
    }

    protected abstract @NonNull CommandProperties properties();

    protected abstract @NonNull Command.Builder<? extends C> configure(@NonNull Command.Builder<C> var1);

    @Override
    public void execute(@NonNull CommandContext<C> commandContext) {
    }
}

