/*
 * Decompiled with CFR 0.152.
 */
package gaia.libraries.linbus.stream.impl;

import gaia.libraries.linbus.common.LinTagId;
import gaia.libraries.linbus.stream.LinStream;
import gaia.libraries.linbus.stream.exception.NbtParseException;
import gaia.libraries.linbus.stream.impl.ValueCounter;
import gaia.libraries.linbus.stream.token.LinToken;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class OptionalInfoCalculator
implements LinStream {
    private final LinStream original;
    private @Nullable Deque<LinToken> tokenBuffer;

    public OptionalInfoCalculator(LinStream original) {
        this.original = original;
    }

    @Override
    public @Nullable LinToken nextOrNull() throws IOException {
        LinToken next;
        if (this.tokenBuffer != null) {
            next = this.tokenBuffer.pollFirst();
            if (next != null) {
                return next;
            }
            this.tokenBuffer = null;
        }
        if ((next = this.original.nextOrNull()) == null) {
            return null;
        }
        TokenAndBuffer tokenAndBuffer = this.fillIfNeeded(next);
        if (tokenAndBuffer.buffer != null && !tokenAndBuffer.buffer.isEmpty()) {
            this.tokenBuffer = tokenAndBuffer.buffer;
        }
        return tokenAndBuffer.token;
    }

    @Override
    public LinStream calculateOptionalInfo() {
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private TokenAndBuffer fillIfNeeded(LinToken token) throws IOException {
        v0 = token;
        Objects.requireNonNull(v0);
        var2_2 = v0;
        var3_4 = 0;
        block12: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LinToken.ListStart.class, LinToken.ByteArrayStart.class, LinToken.IntArrayStart.class, LinToken.LongArrayStart.class, LinToken.Name.class}, (Object)var2_2, var3_4)) {
                case 0: {
                    listStart = (LinToken.ListStart)var2_2;
                    if (!listStart.size().isEmpty() && !listStart.elementId().isEmpty()) {
                        var3_4 = 1;
                        continue block12;
                    }
                    v1 = this.getFilled(new ListStartFill(listStart));
                    break block12;
                }
                case 1: {
                    byteArrayStart = (LinToken.ByteArrayStart)var2_2;
                    if (byteArrayStart.size().isPresent()) {
                        v1 = new TokenAndBuffer(token, null);
                        break block12;
                    }
                    v1 = this.getFilled(new ByteArrayStartFill());
                    break block12;
                }
                case 2: {
                    var6_13 = (LinToken.IntArrayStart)var2_2;
                    size = var8_6 = var6_13.size();
                    if (!size.isPresent()) ** GOTO lbl29
                    v1 = new TokenAndBuffer(token, null);
                    break block12;
lbl29:
                    // 1 sources

                    v1 = this.getFilled(new IntArrayStartFill());
                    break block12;
                }
                case 3: {
                    var8_6 = (LinToken.LongArrayStart)var2_2;
                    size = var10_8 = var8_6.size();
                    if (size.isEmpty()) ** GOTO lbl38
                    var3_4 = 4;
                    continue block12;
lbl38:
                    // 1 sources

                    v1 = this.getFilled(new LongArrayStartFill());
                    break block12;
                }
                case 4: {
                    var10_8 = (LinToken.Name)var2_2;
                    var13_11 = var10_8.name();
                    name = var13_11;
                    id = var13_11 = var10_8.id();
                    if (id.isEmpty()) ** GOTO lbl50
                    var3_4 = 5;
                    continue block12;
lbl50:
                    // 1 sources

                    v1 = this.getFilled(new NameFill(name));
                    break block12;
                }
                default: {
                    v1 = new TokenAndBuffer(token, null);
                    break block12;
                }
            }
            break;
        }
        return v1;
        catch (Throwable var2_3) {
            throw new MatchException(var2_3.toString(), var2_3);
        }
    }

    private TokenAndBuffer getFilled(OptionalFill fill) throws IOException {
        LinToken filled;
        ArrayDeque<LinToken> buffer = new ArrayDeque<LinToken>();
        ArrayDeque<LinToken> consumedTokenStack = new ArrayDeque<LinToken>();
        while (true) {
            LinToken next;
            if ((next = (LinToken)buffer.pollFirst()) == null) {
                LinToken originalNext = this.original.nextOrNull();
                if (originalNext == null) {
                    throw new NbtParseException("Optional value not filled by the end of token stream");
                }
                TokenAndBuffer tokenAndBuffer = this.fillIfNeeded(originalNext);
                buffer.add(tokenAndBuffer.token);
                consumedTokenStack.add(tokenAndBuffer.token);
                if (tokenAndBuffer.buffer == null) continue;
                buffer.addAll(tokenAndBuffer.buffer);
                consumedTokenStack.addAll(tokenAndBuffer.buffer);
                continue;
            }
            filled = fill.tryFill(next);
            if (filled != null) break;
        }
        return new TokenAndBuffer(filled, consumedTokenStack);
    }

    private record TokenAndBuffer(LinToken token, @Nullable Deque<LinToken> buffer) {
    }

    private static final class ListStartFill
    implements OptionalFill {
        private final int knownSize;
        private final @Nullable ValueCounter counter;
        private @Nullable LinTagId elementId;

        public ListStartFill(LinToken.ListStart listStart) {
            if (listStart.size().isPresent()) {
                this.knownSize = listStart.size().getAsInt();
                this.counter = null;
            } else {
                this.knownSize = -1;
                this.counter = new ValueCounter();
            }
            this.elementId = listStart.elementId().orElse(null);
        }

        @Override
        public @Nullable LinToken tryFill(LinToken token) {
            if (this.counter == null || !this.counter.isNested()) {
                LinTagId elementId = this.elementId;
                if (elementId == null) {
                    elementId = token instanceof LinToken.ListEnd ? LinTagId.END : token.tagId().orElseThrow(() -> new NbtParseException("Token doesn't represent a tag directly: " + String.valueOf(token)));
                    this.elementId = elementId;
                }
                if (this.counter == null) {
                    return new LinToken.ListStart(this.knownSize, elementId);
                }
                if (token instanceof LinToken.ListEnd) {
                    return new LinToken.ListStart(this.counter.count(), elementId);
                }
            }
            this.counter.add(token);
            return null;
        }
    }

    private static interface OptionalFill {
        public @Nullable LinToken tryFill(LinToken var1);
    }

    private static final class ByteArrayStartFill
    implements OptionalFill {
        private int size;

        private ByteArrayStartFill() {
        }

        @Override
        public @Nullable LinToken tryFill(LinToken token) {
            if (token instanceof LinToken.ByteArrayEnd) {
                return new LinToken.ByteArrayStart(this.size);
            }
            if (token instanceof LinToken.ByteArrayContent) {
                LinToken.ByteArrayContent content = (LinToken.ByteArrayContent)token;
                this.size += content.buffer().remaining();
            } else {
                throw new NbtParseException("Unexpected token: " + String.valueOf(token));
            }
            return null;
        }
    }

    private static final class IntArrayStartFill
    implements OptionalFill {
        private int size;

        private IntArrayStartFill() {
        }

        @Override
        public @Nullable LinToken tryFill(LinToken token) {
            if (token instanceof LinToken.IntArrayEnd) {
                return new LinToken.IntArrayStart(this.size);
            }
            if (token instanceof LinToken.IntArrayContent) {
                LinToken.IntArrayContent content = (LinToken.IntArrayContent)token;
                this.size += content.buffer().remaining();
            } else {
                throw new NbtParseException("Unexpected token: " + String.valueOf(token));
            }
            return null;
        }
    }

    private static final class LongArrayStartFill
    implements OptionalFill {
        private int size;

        private LongArrayStartFill() {
        }

        @Override
        public @Nullable LinToken tryFill(LinToken token) {
            if (token instanceof LinToken.LongArrayEnd) {
                return new LinToken.LongArrayStart(this.size);
            }
            if (token instanceof LinToken.LongArrayContent) {
                LinToken.LongArrayContent content = (LinToken.LongArrayContent)token;
                this.size += content.buffer().remaining();
            } else {
                throw new NbtParseException("Unexpected token: " + String.valueOf(token));
            }
            return null;
        }
    }

    private record NameFill(String name) implements OptionalFill
    {
        @Override
        public LinToken tryFill(LinToken token) {
            return new LinToken.Name(this.name, token.tagId().orElseThrow(() -> new NbtParseException("Token doesn't represent a tag directly: " + String.valueOf(token))));
        }
    }
}

