/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.api.operation;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.chunk.ChunkPosition;
import me.moros.gaia.api.chunk.Snapshot;
import me.moros.gaia.api.operation.AnalyzeOp;
import me.moros.gaia.api.operation.RevertOp;
import me.moros.gaia.api.platform.Level;

public interface GaiaOperation<T> {
    public long startTime();

    public Result update();

    public CompletableFuture<T> asFuture();

    public static Revert revert(Level level, Snapshot snapshot, int sectionsPerTick) {
        Objects.requireNonNull(level);
        Objects.requireNonNull(snapshot);
        return new RevertOp(level, snapshot, sectionsPerTick);
    }

    public static Analyze snapshotAnalyze(Level level, ChunkRegion chunk) {
        Objects.requireNonNull(level);
        Objects.requireNonNull(chunk);
        return new AnalyzeOp(level, chunk);
    }

    public static sealed interface Analyze
    extends ChunkOperation<Snapshot>
    permits AnalyzeOp {
    }

    public static sealed interface Revert
    extends ChunkOperation<Void>
    permits RevertOp {
    }

    public static interface ChunkOperation<T>
    extends GaiaOperation<T>,
    ChunkPosition {
        public ChunkRegion chunk();

        public Level level();
    }

    public static enum Result {
        CONTINUE,
        WAIT,
        REMOVE;

    }
}

