/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.moros.gaia.api.util.supplier.Suppliers;

public final class GaiaFactory {
    private final Map<Class<?>, Supplier<?>> factoryMappings = new ConcurrentHashMap();

    public <T> GaiaFactory bind(Class<T> type, Supplier<? extends T> supplier) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(supplier);
        this.factoryMappings.put(type, Suppliers.lazy(supplier));
        return this;
    }

    public <T> T build(Class<T> type) {
        Supplier<?> supplier = this.factoryMappings.get(type);
        if (supplier == null) {
            throw new IllegalArgumentException("No mapping found to construct " + type.getName());
        }
        return (T)supplier.get();
    }
}

