/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.command;

import gaia.libraries.cloud.Command;
import gaia.libraries.cloud.CommandManager;
import gaia.libraries.cloud.minecraft.extras.MinecraftExceptionHandler;
import gaia.libraries.cloud.minecraft.extras.RichDescription;
import java.util.List;
import java.util.function.Function;
import me.moros.gaia.api.Gaia;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.common.command.Commander;
import me.moros.gaia.common.command.GaiaCommand;
import me.moros.gaia.common.command.commands.ArenaCommand;
import me.moros.gaia.common.command.commands.HelpCommand;
import me.moros.gaia.common.command.commands.PointCommand;
import me.moros.gaia.common.command.commands.VersionCommand;
import me.moros.gaia.common.locale.Message;
import net.kyori.adventure.text.ComponentLike;
import org.slf4j.Logger;

record CommanderImpl(CommandManager<GaiaUser> manager, Gaia plugin, Logger logger) implements Commander
{
    CommanderImpl init() {
        this.registerExceptionHandler();
        List<Function<Commander, GaiaCommand>> cmds = List.of(ArenaCommand::new, HelpCommand::new, PointCommand::new, VersionCommand::new);
        cmds.forEach(cmd -> ((GaiaCommand)cmd.apply(this)).register());
        return this;
    }

    @Override
    public Command.Builder<GaiaUser> rootBuilder() {
        return this.manager().commandBuilder("gaia", RichDescription.of((ComponentLike)Message.BASE_CMD_DESC.build()), "g");
    }

    @Override
    public void register(Command.Builder<GaiaUser> builder) {
        this.manager().command(builder);
    }

    private void registerExceptionHandler() {
        MinecraftExceptionHandler.createNative().defaultHandlers().decorator(Message::brand).registerTo(this.manager());
    }
}

