/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.locale;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.moros.gaia.common.util.Debounced;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationStore;
import net.kyori.adventure.translation.Translator;
import net.kyori.adventure.util.UTF8ResourceBundleControl;
import org.slf4j.Logger;
import org.spongepowered.configurate.reference.WatchServiceListener;

public final class TranslationManager {
    private static final String PATH = "gaia.lang.messages_en";
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private final Logger logger;
    private final Path translationsDirectory;
    private final AtomicReference<TranslationStore.StringBased<MessageFormat>> registryReference;
    private final Debounced<?> buffer;

    public TranslationManager(Logger logger, Path directory, WatchServiceListener listener) {
        this.logger = logger;
        try {
            this.translationsDirectory = Files.createDirectories(directory.resolve("translations"), new FileAttribute[0]);
            TranslationStore.StringBased<MessageFormat> registry = this.createRegistry(new HashSet<Locale>());
            this.registryReference = new AtomicReference<TranslationStore.StringBased<MessageFormat>>(registry);
            GlobalTranslator.translator().addSource(registry);
            this.buffer = Debounced.create(this::reload, 2L, TimeUnit.SECONDS);
            listener.listenToDirectory(this.translationsDirectory, e -> this.buffer.request());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void reload() {
        LinkedHashSet<Locale> localeSet = new LinkedHashSet<Locale>();
        TranslationStore.StringBased<MessageFormat> newRegistry = this.createRegistry(localeSet);
        TranslationStore.StringBased<MessageFormat> old = this.registryReference.getAndSet(newRegistry);
        GlobalTranslator.translator().removeSource(old);
        GlobalTranslator.translator().addSource(newRegistry);
        int amount = localeSet.size();
        if (amount > 0) {
            String translations = localeSet.stream().map(Locale::getLanguage).collect(Collectors.joining(", ", "[", "]"));
            this.logger.info(String.format("Loaded %d translations: %s", amount, translations));
        }
    }

    private TranslationStore.StringBased<MessageFormat> createRegistry(Set<Locale> localeSet) {
        TranslationStore.StringBased registry = TranslationStore.messageFormat((Key)Key.key((String)"gaia", (String)"translations"));
        registry.defaultLocale(DEFAULT_LOCALE);
        this.loadCustom((TranslationStore.StringBased<MessageFormat>)registry, localeSet);
        this.loadDefaults((TranslationStore.StringBased<MessageFormat>)registry);
        return registry;
    }

    private void loadDefaults(TranslationStore.StringBased<MessageFormat> registry) {
        ResourceBundle bundle = ResourceBundle.getBundle(PATH, DEFAULT_LOCALE, UTF8ResourceBundleControl.utf8ResourceBundleControl());
        registry.registerAll(DEFAULT_LOCALE, bundle, false);
    }

    private void loadCustom(TranslationStore.StringBased<MessageFormat> registry, Set<Locale> localeSet) {
        List<Object> paths;
        try (Stream<Path> stream = Files.list(this.translationsDirectory);){
            paths = stream.filter(this::isValidPropertyFile).toList();
        }
        catch (IOException e) {
            paths = List.of();
        }
        for (Path path : paths) {
            this.loadTranslationFile(path, (locale, bundle) -> {
                registry.registerAll(locale, (ResourceBundle)bundle, false);
                localeSet.add((Locale)locale);
            });
        }
    }

    private void loadTranslationFile(Path path, BiConsumer<Locale, PropertyResourceBundle> consumer) {
        PropertyResourceBundle bundle;
        String localeString = this.removeFileExtension(path);
        Locale locale = Translator.parseLocale((String)localeString);
        if (locale == null) {
            this.logger.warn("Unknown locale: " + localeString);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            bundle = new PropertyResourceBundle(reader);
        }
        catch (IOException e) {
            this.logger.warn("Error loading locale file: " + localeString);
            return;
        }
        consumer.accept(locale, bundle);
    }

    private boolean isValidPropertyFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".properties");
    }

    private String removeFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        return fileName.substring(0, fileName.length() - ".properties".length());
    }
}

