/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.platform;

import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.chunk.Snapshot;
import me.moros.gaia.api.util.ChunkUtil;
import me.moros.gaia.common.platform.codec.Codecs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;

record VanillaSnapshot(ChunkRegion chunk, Section[] sectionData) implements Snapshot
{
    private static final Section EMPTY_SECTION = (x, y, z) -> Blocks.AIR.defaultBlockState();

    @Override
    public String getStateString(int x, int y, int z) {
        return Codecs.blockStateCodec().toString(this.sectionData[ChunkUtil.toChunkPos(y)].state(x, y, z));
    }

    @Override
    public int sections() {
        return this.sectionData.length;
    }

    static VanillaSnapshot from(ChunkRegion chunk, ChunkAccess access) {
        int size = ChunkUtil.calculateSections(chunk.region());
        LevelChunkSection[] cs = access.getSections();
        int sectionIndexOffset = access.getSectionIndex(chunk.region().min().blockY());
        Section[] sections = new Section[size];
        for (int i = 0; i < sections.length; ++i) {
            sections[i] = VanillaSnapshot.copySection(cs[sectionIndexOffset + i]);
        }
        return new VanillaSnapshot(chunk, sections);
    }

    private static Section copySection(LevelChunkSection section) {
        return section.hasOnlyAir() ? EMPTY_SECTION : new SectionWrapper((PalettedContainer<BlockState>)section.getStates().copy());
    }

    @FunctionalInterface
    static interface Section {
        public BlockState state(int var1, int var2, int var3);
    }

    private record SectionWrapper(PalettedContainer<BlockState> palettedContainer) implements Section
    {
        @Override
        public BlockState state(int x, int y, int z) {
            return (BlockState)this.palettedContainer.get(x & 0xF, y & 0xF, z & 0xF);
        }
    }
}

