/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.service;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import me.moros.gaia.api.Gaia;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.chunk.ChunkPosition;
import me.moros.gaia.api.operation.GaiaOperation;
import me.moros.gaia.api.platform.Level;
import me.moros.gaia.api.service.OperationService;
import me.moros.gaia.common.config.ConfigManager;
import me.moros.tasker.executor.SyncExecutor;

public final class OperationServiceImpl
implements OperationService {
    private final Gaia plugin;
    private final Queue<GaiaOperation.ChunkOperation<?>> queue;
    private final AtomicBoolean updatedConfig;
    private int concurrentChunks;
    private boolean valid;

    public OperationServiceImpl(Gaia plugin, SyncExecutor syncExecutor) {
        this.plugin = plugin;
        this.queue = new ConcurrentLinkedQueue();
        this.updatedConfig = new AtomicBoolean(true);
        this.tryRefreshLimits();
        ConfigManager.instance().subscribe(n -> this.updatedConfig.set(true));
        syncExecutor.repeat(this::processTasks, 1, 1);
        this.valid = true;
    }

    private void tryRefreshLimits() {
        if (this.updatedConfig.compareAndSet(true, false)) {
            this.concurrentChunks = ConfigManager.instance().config().concurrentChunks();
        }
    }

    private void processTasks() {
        if (!this.valid) {
            return;
        }
        if (this.queue.isEmpty()) {
            this.tryRefreshLimits();
            return;
        }
        long startTime = System.currentTimeMillis();
        Iterator it = this.queue.iterator();
        int counter = 0;
        while (counter < this.concurrentChunks && it.hasNext()) {
            GaiaOperation.ChunkOperation operation = (GaiaOperation.ChunkOperation)it.next();
            GaiaOperation.Result result = operation.update();
            if (result == GaiaOperation.Result.REMOVE) {
                this.onComplete(operation);
                it.remove();
            }
            if (result != GaiaOperation.Result.WAIT) {
                ++counter;
            }
            if (System.currentTimeMillis() <= startTime + 30L) continue;
            break;
        }
    }

    @Override
    public void shutdown() {
        this.valid = false;
        this.queue.forEach(op -> {
            op.asFuture().cancel(false);
            this.cleanupChunk(op.level(), (ChunkPosition)op);
        });
        this.queue.clear();
    }

    @Override
    public int remainingOperations() {
        return this.queue.size();
    }

    @Override
    public <T> CompletableFuture<T> add(GaiaOperation.ChunkOperation<T> operation) {
        if (this.valid) {
            operation.level().loadChunkWithTicket(operation.x(), operation.z()).thenAccept(ignore -> this.queue.offer(operation));
            return operation.asFuture();
        }
        return CompletableFuture.failedFuture(new RuntimeException("Unable to queue operation!"));
    }

    private void onComplete(GaiaOperation.ChunkOperation<?> op) {
        if (op.asFuture().isDone() && !op.asFuture().isCompletedExceptionally()) {
            long deltaTime = System.currentTimeMillis() - op.startTime();
            if (op instanceof GaiaOperation.Analyze) {
                this.plugin.eventBus().postChunkAnalyzeEvent(op.chunk(), op.level().key(), deltaTime);
            } else if (op instanceof GaiaOperation.Revert) {
                this.plugin.eventBus().postChunkRevertEvent(op.chunk(), op.level().key(), deltaTime);
            }
        }
        this.cleanupChunk(op.level(), op);
    }

    @Override
    public void cancel(Level level, ChunkRegion chunk) {
        this.queue.removeIf(op -> this.cancelMatching((GaiaOperation.ChunkOperation<?>)op, level, chunk));
        this.cleanupChunk(level, chunk);
    }

    private boolean cancelMatching(GaiaOperation.ChunkOperation<?> op, Level level, ChunkPosition pos) {
        if (op.level().key().equals((Object)level.key()) && op.x() == pos.x() && op.z() == pos.z()) {
            op.asFuture().cancel(false);
            return true;
        }
        return false;
    }

    private void cleanupChunk(Level level, ChunkPosition position) {
        level.removeChunkTicket(position.x(), position.z());
    }
}

