/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.storage.serializer;

import java.lang.reflect.Type;
import java.util.Locale;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.arena.region.Region;
import me.moros.gaia.common.storage.serializer.AbstractSerializer;
import me.moros.math.Vector3i;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

final class ChunkRegionSerializer
extends AbstractSerializer<ChunkRegion.Validated> {
    static final ChunkRegionSerializer INSTANCE = new ChunkRegionSerializer();
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String CHECKSUM = "checksum";

    private ChunkRegionSerializer() {
    }

    public ChunkRegion.Validated deserialize(Type type, ConfigurationNode source) throws SerializationException {
        long checksum;
        Vector3i min = (Vector3i)ChunkRegionSerializer.nonVirtualNode(source, MIN).get(Vector3i.class);
        Vector3i max = (Vector3i)ChunkRegionSerializer.nonVirtualNode(source, MAX).get(Vector3i.class);
        if (min == null || max == null) {
            throw new SerializationException("A min and max are required to deserialize a ChunkRegion");
        }
        try {
            checksum = Long.parseLong(ChunkRegionSerializer.nonVirtualNode(source, CHECKSUM).getString(""), 16);
        }
        catch (NumberFormatException e) {
            throw new SerializationException((Throwable)e);
        }
        return ChunkRegion.create(Region.of(min, max), checksum);
    }

    public void serialize(Type type, @Nullable ChunkRegion.Validated chunk, ConfigurationNode target) throws SerializationException {
        if (chunk == null) {
            target.raw(null);
            return;
        }
        target.node(new Object[]{MIN}).set(Vector3i.class, (Object)chunk.region().min());
        target.node(new Object[]{MAX}).set(Vector3i.class, (Object)chunk.region().max());
        target.node(new Object[]{CHECKSUM}).set((Object)Long.toHexString(chunk.checksum()).toUpperCase(Locale.ROOT));
    }
}

