/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.util;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class VarIntIterator
implements PrimitiveIterator.OfInt {
    private final byte[] source;
    private int remaining;
    private int index;

    public VarIntIterator(byte[] source, int expected) {
        this.source = source;
        this.remaining = expected;
    }

    public int index() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        return this.remaining > 0;
    }

    private int readNextInt() {
        int value = 0;
        int bitsRead = 0;
        while (true) {
            byte next = this.source[this.index];
            ++this.index;
            value |= (next & 0x7F) << bitsRead;
            if ((next & 0x80) == 0) break;
            bitsRead += 7;
        }
        --this.remaining;
        return value;
    }

    @Override
    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.readNextInt();
    }
}

