/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.paper.platform;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.moros.gaia.api.chunk.ChunkPosition;
import me.moros.gaia.common.platform.VanillaLevel;
import me.moros.gaia.paper.platform.Folia;
import me.moros.gaia.paper.platform.RegionExecutor;
import net.kyori.adventure.key.Key;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.Ticket;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BukkitLevel
extends VanillaLevel {
    private final World bukkitWorld;
    private final RegionExecutor executor;

    public BukkitLevel(World world, RegionExecutor executor) {
        super(((CraftWorld)world).getHandle());
        this.bukkitWorld = world;
        this.executor = executor;
    }

    public @NonNull Key key() {
        return this.bukkitWorld.key();
    }

    @Override
    protected CompletableFuture<ChunkAccess> loadChunkAsync(int x, int z) {
        if (Folia.FOLIA) {
            return this.bukkitWorld.getChunkAtAsync(x, z, false).thenApply(c -> this.chunkSource().getChunkNow(x, z));
        }
        return super.loadChunkAsync(x, z);
    }

    @Override
    public void removeChunkTicket(int x, int z) {
        ChunkPos chunkPos = new ChunkPos(x, z);
        Ticket ticket = this.gaiaTicket();
        this.chunkSource().removeTicketAtLevel(ticket.getType(), chunkPos, ticket.getTicketLevel());
    }

    @Override
    public void fixLight(Collection<ChunkPosition> positions) {
        if (Folia.FOLIA) {
            return;
        }
        this.executor.execute(() -> this.fixLightNow(positions));
    }

    private void fixLightNow(Collection<ChunkPosition> positions) {
        ServerChunkCache chunkSource = this.chunkSource();
        Set chunkSet = positions.stream().map(gc -> new ChunkPos(gc.x(), gc.z())).filter(v -> this.filter(chunkSource, (ChunkPos)v)).collect(Collectors.toCollection(LinkedHashSet::new));
        chunkSource.getLightEngine().starlight$serverRelightChunks((Collection)chunkSet, c -> {}, i -> {});
    }

    private boolean filter(ServerChunkCache chunkSource, ChunkPos pos) {
        ChunkAccess chunk = (ChunkAccess)chunkSource.getChunkForLighting(pos.x, pos.z);
        return chunk != null && chunk.isLightCorrect() && chunk.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT);
    }
}

