/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.paper.platform;

import java.util.Optional;
import me.moros.gaia.api.Gaia;
import me.moros.gaia.api.arena.Point;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.paper.platform.BukkitGaiaUser;
import me.moros.math.Vector3d;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

sealed interface GaiaPlayer
extends GaiaUser
permits BukkitGaiaUser.BukkitGaiaPlayer, GaiaPlayerImpl {
    public Player player();

    default public Audience audience() {
        return this.player();
    }

    @Override
    default public boolean isPlayer() {
        return true;
    }

    @Override
    default public void teleport(Key worldKey, Point point) {
        World world = this.player().getServer().getWorld(worldKey);
        if (world != null) {
            this.player().teleportAsync(new Location(world, point.x(), point.y(), point.z(), point.yaw(), point.pitch()));
        }
    }

    @Override
    default public Optional<Key> level() {
        return Optional.of(this.player().getWorld().key());
    }

    @Override
    default public Vector3d position() {
        Location pos = this.player().getLocation();
        return Vector3d.of(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    default public float yaw() {
        return this.player().getYaw();
    }

    @Override
    default public float pitch() {
        return this.player().getPitch();
    }

    public record GaiaPlayerImpl(Gaia parent, Player player) implements GaiaPlayer
    {
    }
}

