/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.paper.service;

import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.moros.gaia.api.Gaia;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.api.service.UserService;
import me.moros.gaia.paper.platform.BukkitGaiaUser;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;

public record UserServiceImpl(Supplier<Gaia> supplier, Server server) implements UserService
{
    @Override
    public @Nullable GaiaUser findUser(UUID uuid) {
        Player player = this.server().getPlayer(uuid);
        return player == null ? null : BukkitGaiaUser.from(this.supplier().get(), player);
    }

    @Override
    public @Nullable GaiaUser findUser(String input) {
        Player player = this.server().getPlayer(input);
        if (player == null) {
            try {
                UUID uuid = UUID.fromString(input);
                player = this.server().getPlayer(uuid);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return player == null ? null : BukkitGaiaUser.from(this.supplier().get(), player);
    }

    @Override
    public Stream<String> users() {
        return this.server().getOnlinePlayers().stream().map(CommandSender::getName);
    }
}

