/*
 * Decompiled with CFR 0.152.
 */
package me.moros.math.adapter;

import java.util.HashMap;
import java.util.Map;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;
import me.moros.math.adapter.Adapter;
import me.moros.math.adapter.Converter;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Adapters<E extends Position> {
    private static final Adapters<Vector3i> INT = new Adapters();
    private static final Adapters<Vector3d> DOUBLE = new Adapters();
    private final Map<Class<?>, Adapter<?, E>> ADAPTERS = new HashMap();
    private final Map<Class<?>, Converter<?>> CONVERTERS = new HashMap();

    private Adapters() {
    }

    public <T> void registerAdapter(Class<T> nativeType, Adapter<T, E> adapter) {
        this.ADAPTERS.put(nativeType, adapter);
    }

    public <T> void registerConverter(Class<T> nativeType, Converter<T> converter) {
        this.CONVERTERS.put(nativeType, converter);
    }

    public <T> void register(Class<T> nativeType, Adapter<T, E> adapter, Converter<T> converter) {
        this.registerAdapter(nativeType, adapter);
        this.registerConverter(nativeType, converter);
    }

    public <T> E adapt(T object) {
        Class<?> type = object.getClass();
        Adapter adapter = this.ADAPTERS.computeIfAbsent(type, this::findClosestAdapter);
        if (adapter == null) {
            throw new IllegalArgumentException("Could not find a registered adapter for " + type.getName());
        }
        return (E)((Position)adapter.apply(object));
    }

    private <T> @Nullable Adapter<T, E> findClosestAdapter(Class<T> type) {
        for (Map.Entry<Class<?>, Adapter<?, E>> entry : this.ADAPTERS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            return entry.getValue();
        }
        return null;
    }

    public <T> Converter<T> converter(Class<T> nativeType) {
        return (Converter)this.getConverter(this.CONVERTERS, nativeType);
    }

    private Object getConverter(Map<Class<?>, ?> map, Class<?> nativeType) {
        Object value = map.get(nativeType);
        if (value == null) {
            throw new IllegalArgumentException("Could not find a registered adapter for " + nativeType.getName());
        }
        return value;
    }

    public static Adapters<Vector3i> vector3i() {
        return INT;
    }

    public static Adapters<Vector3d> vector3d() {
        return DOUBLE;
    }
}

