/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.api.arena;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.arena.Point;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.arena.region.Region;
import me.moros.gaia.api.util.ComponentUtil;
import me.moros.gaia.api.util.supplier.Suppliers;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;

final class ArenaImpl
implements Arena {
    private final String name;
    private final Key level;
    private final Region region;
    private final Supplier<Component> infoSupplier;
    private final List<ChunkRegion.Validated> chunkRegions;
    private final List<Point> points;
    private final AtomicLong lastRevert;

    ArenaImpl(String name, Key level, Region region, Collection<ChunkRegion.Validated> chunkRegions) {
        this.name = name;
        this.level = level;
        this.region = region;
        this.infoSupplier = Suppliers.lazy(() -> ComponentUtil.generateInfo(this));
        this.chunkRegions = List.copyOf(chunkRegions);
        this.points = new CopyOnWriteArrayList<Point>();
        this.lastRevert = new AtomicLong();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Key level() {
        return this.level;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    public Component info() {
        return this.infoSupplier.get();
    }

    @Override
    public long lastReverted() {
        return this.lastRevert.get();
    }

    @Override
    public void resetLastReverted() {
        this.lastRevert.set(System.currentTimeMillis());
    }

    @Override
    public void addPoint(Point point) {
        Objects.requireNonNull(point);
        if (this.region.contains(point)) {
            this.points.add(point);
        }
    }

    @Override
    public void clearPoints() {
        this.points.clear();
    }

    @Override
    public List<Point> points() {
        return List.copyOf(this.points);
    }

    @Override
    public Stream<Point> streamPoints() {
        return this.points.stream();
    }

    @Override
    public List<ChunkRegion.Validated> chunks() {
        return this.chunkRegions;
    }

    @Override
    public Stream<ChunkRegion.Validated> streamChunks() {
        return this.chunkRegions.stream();
    }

    @Override
    public Iterator<ChunkRegion.Validated> iterator() {
        return this.chunkRegions.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Arena) {
            Arena other = (Arena)obj;
            return this.level().equals((Object)other.level()) && this.region().equals(other.region());
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.level().hashCode() + this.region().hashCode();
    }
}

