/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.api.operation;

import java.util.concurrent.CompletableFuture;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.operation.GaiaOperation;
import me.moros.gaia.api.platform.Level;

public abstract class AbstractOp<T>
implements GaiaOperation<T> {
    protected final long startTime = System.currentTimeMillis();
    protected final CompletableFuture<T> future = new CompletableFuture();

    protected AbstractOp() {
    }

    @Override
    public final long startTime() {
        return this.startTime;
    }

    @Override
    public final GaiaOperation.Result update() {
        if (this.future.isDone()) {
            return GaiaOperation.Result.REMOVE;
        }
        return this.processStep();
    }

    @Override
    public final CompletableFuture<T> asFuture() {
        return this.future;
    }

    protected abstract GaiaOperation.Result processStep();

    static abstract class LevelChunkOp<T>
    extends AbstractOp<T>
    implements GaiaOperation.ChunkOperation<T> {
        protected final Level level;
        protected final ChunkRegion chunk;

        protected LevelChunkOp(Level level, ChunkRegion chunk) {
            this.level = level;
            this.chunk = chunk;
        }

        @Override
        public ChunkRegion chunk() {
            return this.chunk;
        }

        @Override
        public Level level() {
            return this.level;
        }

        @Override
        public final int x() {
            return this.chunk.x();
        }

        @Override
        public final int z() {
            return this.chunk.z();
        }
    }
}

