/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.api.operation;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import me.moros.gaia.api.arena.Reversible;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.chunk.Snapshot;
import me.moros.gaia.api.operation.AbstractOp;
import me.moros.gaia.api.operation.GaiaOperation;
import me.moros.gaia.api.platform.Level;

final class RevertOp
extends AbstractOp.LevelChunkOp<Void>
implements GaiaOperation.Revert {
    private Snapshot snapshot;
    private final int amount;
    private final AtomicReference<GaiaOperation.Result> result = new AtomicReference<GaiaOperation.Result>(GaiaOperation.Result.CONTINUE);
    private final Reversible reversible;

    RevertOp(Level level, Snapshot snapshot, int sectionsPerTick) {
        super(level, snapshot.chunk());
        this.snapshot = snapshot;
        int min = Math.min(16, snapshot.sections());
        int max = Math.max(16, snapshot.sections());
        this.amount = Math.clamp((long)sectionsPerTick, min, max) * 4096;
        ChunkRegion chunkRegion = this.chunk();
        if (chunkRegion instanceof Reversible.Mutable) {
            Reversible.Mutable reversibleChunk = (Reversible.Mutable)((Object)chunkRegion);
            this.reversible = reversibleChunk;
            this.future.whenComplete((ignore, throwable) -> reversibleChunk.reverting(false));
        } else {
            this.reversible = null;
        }
    }

    @Override
    protected GaiaOperation.Result processStep() {
        GaiaOperation.Result ret;
        if (this.reversible != null && !this.reversible.reverting()) {
            ret = GaiaOperation.Result.REMOVE;
        } else {
            if (this.result.compareAndSet(GaiaOperation.Result.CONTINUE, GaiaOperation.Result.WAIT)) {
                ((CompletableFuture)this.level.restoreSnapshot(this.snapshot, this.amount).thenApply(hasMore -> this.result.compareAndSet(GaiaOperation.Result.WAIT, hasMore != false ? GaiaOperation.Result.CONTINUE : GaiaOperation.Result.REMOVE))).exceptionally(this.future::completeExceptionally);
            }
            ret = this.result.get();
        }
        if (ret == GaiaOperation.Result.REMOVE) {
            this.snapshot = null;
            this.future.complete(null);
        }
        return ret;
    }
}

