/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.arena.region.Region;
import me.moros.gaia.api.chunk.ChunkPosition;
import me.moros.math.Position;
import me.moros.math.Vector3i;

public final class ChunkUtil {
    public static final int CHUNK_SIZE = 16;
    public static final int CHUNK_SECTION_SIZE = 16;
    public static final int CHUNK_SECTION_VOLUME = 4096;
    private static final int WORLD_XZ_MINMAX = 30000000;
    private static final int WORLD_Y_MIN = -2048;
    private static final int WORLD_Y_MAX = 2047;
    private static final int BIT_MASK = -16;

    private ChunkUtil() {
    }

    private static boolean isValidXZ(int x, int z) {
        return -30000000 <= x && x <= 30000000 && -30000000 <= z && z <= 30000000;
    }

    private static boolean isValidY(int n) {
        return -2048 <= n && n <= 2047;
    }

    public static boolean isValidPosition(Position pos) {
        return ChunkUtil.isValidXZ(pos.blockX(), pos.blockZ()) && ChunkUtil.isValidY(pos.blockY());
    }

    public static void ensureValidPosition(Position pos) throws IllegalArgumentException {
        if (!ChunkUtil.isValidPosition(pos)) {
            throw new IllegalArgumentException(String.format("Position %s exceeds bounds!", pos));
        }
    }

    public static int toChunkPos(int value) {
        return value >> 4;
    }

    public static Vector3i toChunkSectionPos(Position position) {
        return Vector3i.of(position.blockX() & 0xFFFFFFF0, position.blockY() & 0xFFFFFFF0, position.blockZ() & 0xFFFFFFF0);
    }

    public static int calculateChunkVolume(ChunkRegion chunk) {
        int sections = ChunkUtil.calculateSections(chunk.region());
        return 4096 * sections;
    }

    public static List<ChunkPosition> spiralChunks(Region region) {
        int sizeX = ChunkUtil.calculateChunkDistance(region.min().blockX(), region.max().blockX());
        int sizeZ = ChunkUtil.calculateChunkDistance(region.min().blockZ(), region.max().blockZ());
        ChunkPosition centerChunk = ChunkPosition.at(region.center());
        int halfX = sizeX / 2;
        int halfZ = sizeZ / 2;
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = -1;
        int t = Math.max(sizeX, sizeZ);
        int maxI = t * t;
        ArrayList<ChunkPosition> result = new ArrayList<ChunkPosition>();
        for (int i = 0; i < maxI; ++i) {
            if (-halfX <= x && x <= halfX && -halfZ <= z && z <= halfZ) {
                result.add(ChunkPosition.at(centerChunk.x() + x, centerChunk.z() + z));
            }
            if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                t = dx;
                dx = -dz;
                dz = t;
            }
            x += dx;
            z += dz;
        }
        return result;
    }

    public static Collection<ChunkRegion> splitIntoChunks(Region region) {
        int minX = region.min().blockX();
        int maxX = region.max().blockX();
        int minY = region.min().blockY();
        int maxY = region.max().blockY();
        int minZ = region.min().blockZ();
        int maxZ = region.max().blockZ();
        int dx = ChunkUtil.calculateChunkDistance(minX, maxX);
        int dz = ChunkUtil.calculateChunkDistance(minZ, maxZ);
        ArrayList<ChunkRegion> regions = new ArrayList<ChunkRegion>(dx * dz);
        for (int x = ChunkUtil.toChunkPos(minX); x <= ChunkUtil.toChunkPos(maxX); ++x) {
            int tempX = x * 16;
            for (int z = ChunkUtil.toChunkPos(minZ); z <= ChunkUtil.toChunkPos(maxZ); ++z) {
                int tempZ = z * 16;
                Vector3i v1 = ChunkUtil.atXZClamped(tempX, minY, tempZ, minX, maxX, minZ, maxZ);
                Vector3i v2 = ChunkUtil.atXZClamped(tempX + 15, maxY, tempZ + 15, minX, maxX, minZ, maxZ);
                regions.add(ChunkRegion.create(Region.of(v1, v2)));
            }
        }
        return regions;
    }

    public static boolean isValidRegionSize(Region region) {
        return region.size().blockX() <= 16 && region.size().blockZ() <= 16;
    }

    public static void validateRegionSize(Region region) throws IllegalArgumentException {
        if (!ChunkUtil.isValidRegionSize(region)) {
            throw new IllegalArgumentException(String.valueOf(region.size()) + " exceeds chunk size limits!");
        }
    }

    public static int calculateSections(Region region) {
        return 1 + (ChunkUtil.toChunkPos(region.max().blockY()) - ChunkUtil.toChunkPos(region.min().blockY()));
    }

    public static int calculateChunkDistance(int minPos, int maxPos) {
        if (minPos > maxPos) {
            throw new IllegalArgumentException(String.format("Encountered minPos (%d) > maxPos (%d)", minPos, maxPos));
        }
        return Math.max(1, ChunkUtil.toChunkPos(maxPos) - ChunkUtil.toChunkPos(minPos));
    }

    private static Vector3i atXZClamped(int x, int y, int z, int minX, int maxX, int minZ, int maxZ) {
        if (minX > maxX || minZ > maxZ) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum");
        }
        return Vector3i.of(Math.max(minX, Math.min(maxX, x)), y, Math.max(minZ, Math.min(maxZ, z)));
    }
}

