/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import me.moros.gaia.api.Gaia;
import me.moros.gaia.common.GaiaFactory;
import me.moros.gaia.common.GaiaImpl;
import me.moros.gaia.common.config.ConfigManager;
import me.moros.gaia.common.locale.TranslationManager;
import me.moros.gaia.common.util.GaiaProviderUtil;
import org.slf4j.Logger;
import org.spongepowered.configurate.reference.WatchServiceListener;

public abstract class AbstractGaia<T> {
    protected final T parent;
    private final Path path;
    private final Logger logger;
    private final WatchServiceListener listener;
    private final ConfigManager configManager;
    private final TranslationManager translationManager;
    protected final GaiaFactory factory;
    private GaiaImpl gaia;

    protected AbstractGaia(T parent, Path path, Logger logger) {
        this.parent = parent;
        this.path = path;
        this.logger = logger;
        try {
            this.listener = WatchServiceListener.create();
            this.configManager = new ConfigManager(this.logger, this.path, this.listener);
            this.translationManager = new TranslationManager(this.logger, this.path, this.listener);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.factory = new GaiaFactory();
    }

    protected void load() {
        this.gaia = new GaiaImpl(this, this.factory);
        long startTime = System.currentTimeMillis();
        this.gaia.storage().loadAllArenas().thenAccept(arenas -> {
            arenas.forEach(this.gaia.arenaService()::add);
            long delta = System.currentTimeMillis() - startTime;
            int size = this.gaia.arenaService().size();
            this.logger.info(String.format("Successfully loaded %d %s (%dms)", size, size == 1 ? "arena" : "arenas", delta));
        });
        GaiaProviderUtil.registerProvider(this.gaia);
    }

    protected void disable() {
        GaiaProviderUtil.unregisterProvider();
        this.configManager.close();
        try {
            this.listener.close();
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        this.gaia.shutdown();
    }

    protected Path path() {
        return this.path;
    }

    protected Logger logger() {
        return this.logger;
    }

    protected Gaia api() {
        return this.gaia;
    }
}

