/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.command;

import java.util.List;
import java.util.function.Function;
import me.moros.gaia.api.Gaia;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.common.command.Commander;
import me.moros.gaia.common.command.GaiaCommand;
import me.moros.gaia.common.command.commands.ArenaCommand;
import me.moros.gaia.common.command.commands.HelpCommand;
import me.moros.gaia.common.command.commands.PointCommand;
import me.moros.gaia.common.command.commands.VersionCommand;
import me.moros.gaia.common.locale.Message;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.extras.MinecraftExceptionHandler;
import org.incendo.cloud.minecraft.extras.RichDescription;
import org.slf4j.Logger;

record CommanderImpl(CommandManager<GaiaUser> manager, Gaia plugin, Logger logger) implements Commander
{
    CommanderImpl init() {
        this.registerExceptionHandler();
        List<Function<Commander, GaiaCommand>> cmds = List.of(ArenaCommand::new, HelpCommand::new, PointCommand::new, VersionCommand::new);
        cmds.forEach(cmd -> ((GaiaCommand)cmd.apply(this)).register());
        return this;
    }

    @Override
    public Command.Builder<GaiaUser> rootBuilder() {
        return this.manager().commandBuilder("gaia", (Description)RichDescription.of((ComponentLike)Message.BASE_CMD_DESC.build()), new String[]{"g"});
    }

    @Override
    public void register(Command.Builder<GaiaUser> builder) {
        this.manager().command(builder);
    }

    private void registerExceptionHandler() {
        MinecraftExceptionHandler.createNative().defaultHandlers().decorator(Message::brand).registerTo(this.manager());
    }
}

