/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.command.commands;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.arena.Point;
import me.moros.gaia.api.arena.RevertResult;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.api.util.ComponentUtil;
import me.moros.gaia.api.util.TextUtil;
import me.moros.gaia.common.command.CommandPermissions;
import me.moros.gaia.common.command.Commander;
import me.moros.gaia.common.command.GaiaCommand;
import me.moros.gaia.common.command.parser.ArenaParser;
import me.moros.gaia.common.command.parser.GaiaUserParser;
import me.moros.gaia.common.config.ConfigManager;
import me.moros.gaia.common.locale.Message;
import me.moros.gaia.common.util.UserArenaFactory;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.incendo.cloud.Command;
import org.incendo.cloud.component.DefaultValue;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.extras.RichDescription;
import org.incendo.cloud.parser.standard.IntegerParser;
import org.incendo.cloud.parser.standard.StringParser;

public record ArenaCommand(Commander commander) implements GaiaCommand
{
    private static final int AMOUNT_PER_PAGE = 12;

    @Override
    public void register() {
        Command.Builder<GaiaUser> builder = this.commander().rootBuilder();
        this.commander().register((Command.Builder<GaiaUser>)builder.literal("list", new String[0]).optional("page", IntegerParser.integerParser((int)1), DefaultValue.constant((Object)1)).commandDescription((Description)RichDescription.of((ComponentLike)Message.LIST_CMD_DESC.build())).permission(CommandPermissions.LIST).handler(c -> this.onList((GaiaUser)c.sender(), (Integer)c.get("page"))));
        this.commander().register((Command.Builder<GaiaUser>)builder.literal("info", new String[0]).optional("arena", ArenaParser.parser(), DefaultValue.parsed((String)"cur")).commandDescription((Description)RichDescription.of((ComponentLike)Message.INFO_CMD_DESC.build())).permission(CommandPermissions.INFO).handler(c -> this.onInfo((GaiaUser)c.sender(), (Arena)c.get("arena"))));
        this.commander().register((Command.Builder<GaiaUser>)builder.literal("create", new String[0]).optional("name", StringParser.stringParser()).commandDescription((Description)RichDescription.of((ComponentLike)Message.CREATE_CMD_DESC.build())).permission(CommandPermissions.CREATE).handler(c -> this.onCreate((GaiaUser)c.sender(), (String)c.get("name"))));
        this.commander().register((Command.Builder<GaiaUser>)builder.literal("remove", new String[0]).required("arena", ArenaParser.parser()).commandDescription((Description)RichDescription.of((ComponentLike)Message.REMOVE_CMD_DESC.build())).permission(CommandPermissions.REMOVE).handler(c -> this.onRemove((GaiaUser)c.sender(), (Arena)c.get("arena"))));
        this.commander().register((Command.Builder<GaiaUser>)builder.literal("revert", new String[0]).optional("arena", ArenaParser.parser(), DefaultValue.parsed((String)"cur")).optional("target", GaiaUserParser.parser(), DefaultValue.parsed((String)"me")).commandDescription((Description)RichDescription.of((ComponentLike)Message.REVERT_CMD_DESC.build())).permission(CommandPermissions.REVERT).handler(c -> this.onRevert((GaiaUser)c.get("target"), (Arena)c.get("arena"))));
    }

    private void onList(GaiaUser user, int page) {
        int count = user.parent().arenaService().size();
        if (count == 0) {
            Message.LIST_NOT_FOUND.send((Audience)user);
            return;
        }
        int totalPages = (int)Math.ceil((double)count / 12.0);
        if (page > totalPages) {
            Message.LIST_INVALID_PAGE.send((Audience)user, totalPages);
            return;
        }
        int skip = (page - 1) * 12;
        TextComponent.Builder builder = (TextComponent.Builder)Component.text().append((Component)Component.text((String)"Arenas - Page ", (TextColor)NamedTextColor.DARK_AQUA));
        if (page > 1) {
            builder.append(ArenaCommand.generatePaging(false, page - 1));
        }
        ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.text((int)page, (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" of ", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.text((int)totalPages, (TextColor)NamedTextColor.GREEN));
        if (page < totalPages) {
            builder.append(ArenaCommand.generatePaging(true, page + 1));
        }
        user.sendMessage((Component)builder.build());
        user.parent().arenaService().stream().sorted(Comparator.comparing(Arena::name)).skip(skip).limit(12L).map(ComponentUtil::arenaInfoAsHover).forEach(arg_0 -> ((GaiaUser)user).sendMessage(arg_0));
        user.sendMessage((Component)Component.text((String)TextUtil.generateLine(44), (TextColor)NamedTextColor.DARK_AQUA));
    }

    private void onInfo(GaiaUser user, Arena arena) {
        Message.INFO_HEADER.send((Audience)user);
        user.sendMessage(arena.info());
        List<Point> points = arena.points();
        if (points.isEmpty()) {
            return;
        }
        ListIterator<Point> it = points.listIterator();
        ArrayList<Component> components = new ArrayList<Component>();
        while (it.hasNext()) {
            components.add(ComponentUtil.generatePointInfo(arena, it.next(), it.nextIndex()));
        }
        JoinConfiguration sep = JoinConfiguration.separator((ComponentLike)Component.text((String)", ", (TextColor)NamedTextColor.GRAY));
        Message.LIST_POINTS.send((Audience)user, arena.displayName());
        user.sendMessage(Component.join((JoinConfiguration)sep, components));
    }

    private void onCreate(GaiaUser user, String name) {
        if (!user.isPlayer()) {
            Message.PLAYER_REQUIRED.send((Audience)user);
            return;
        }
        new UserArenaFactory(user, this.commander().logger()).tryCreate(name);
    }

    private void onRemove(GaiaUser user, Arena arena) {
        String arenaName = arena.name();
        if (user.parent().arenaService().remove(arenaName)) {
            Message.REMOVE_SUCCESS.send((Audience)user, arenaName);
        } else {
            Message.REMOVE_FAIL.send((Audience)user, arenaName);
        }
    }

    private void onRevert(GaiaUser user, Arena arena) {
        if (user.isPlayer() && !this.hasBypass(user)) {
            long cooldown = ConfigManager.instance().config().cooldown();
            long deltaTime = arena.lastReverted() + cooldown - System.currentTimeMillis();
            if (deltaTime > 0L) {
                Message.REVERT_COOLDOWN.send((Audience)user, deltaTime);
                return;
            }
        }
        RevertResult revertResult = user.parent().arenaService().revert(arena);
        user.sendMessage(revertResult.message());
        revertResult.future().whenComplete((result, e) -> {
            if (e == null) {
                user.sendMessage(Message.FINISHED_REVERT.build(arena.displayName(), (Long)result));
            } else {
                user.sendMessage(Message.REVERT_ERROR_UNKNOWN.build(arena.displayName()));
                this.commander().logger().error(e.getMessage(), e);
            }
        });
    }

    private boolean hasBypass(GaiaUser user) {
        return user.get(PermissionChecker.POINTER).map(c -> c.test(CommandPermissions.BYPASS.toString())).orElse(false);
    }

    private static Component generatePaging(boolean forward, int page) {
        return ((TextComponent)Component.text((String)(forward ? " >>>" : "<<< "), (TextColor)NamedTextColor.GOLD).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Click to navigate to page " + page), (TextColor)NamedTextColor.GRAY)))).clickEvent(ClickEvent.runCommand((String)("/gaia list " + page)));
    }
}

