/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.command.parser;

import me.moros.gaia.api.arena.Arena;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.api.util.TextUtil;
import me.moros.math.Vector3i;
import net.kyori.adventure.key.Key;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;

public final class ArenaParser
implements ArgumentParser<GaiaUser, Arena>,
BlockingSuggestionProvider.Strings<GaiaUser> {
    private ArenaParser() {
    }

    public ArgumentParseResult<Arena> parse(CommandContext<GaiaUser> commandContext, CommandInput commandInput) {
        Arena result;
        String input = TextUtil.sanitizeInput(commandInput.peekString());
        GaiaUser user = (GaiaUser)commandContext.sender();
        if (input.equalsIgnoreCase("cur")) {
            Vector3i pos = user.position().toVector3i();
            result = user.level().flatMap(levelKey -> user.parent().arenaService().arena((Key)levelKey, pos)).orElse(null);
        } else {
            result = user.parent().arenaService().arena(input).orElse(null);
        }
        if (result != null) {
            commandInput.readString();
            return ArgumentParseResult.success((Object)result);
        }
        return ArgumentParseResult.failure((Throwable)new Throwable("Could not find the specified arena"));
    }

    public Iterable<String> stringSuggestions(CommandContext<GaiaUser> commandContext, CommandInput commandInput) {
        return ((GaiaUser)commandContext.sender()).parent().arenaService().stream().map(Arena::name).sorted().toList();
    }

    public static ParserDescriptor<GaiaUser, Arena> parser() {
        return ParserDescriptor.of((ArgumentParser)new ArenaParser(), Arena.class);
    }
}

