/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.platform;

import java.util.concurrent.CompletableFuture;
import me.moros.gaia.api.arena.region.ChunkRegion;
import me.moros.gaia.api.chunk.Snapshot;
import me.moros.gaia.api.platform.Level;
import me.moros.gaia.api.util.ChunkUtil;
import me.moros.gaia.common.platform.GaiaSnapshot;
import me.moros.gaia.common.platform.VanillaSnapshot;
import me.moros.gaia.common.util.IndexedIterator;
import me.moros.math.Vector3i;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_8563;

public abstract class VanillaLevel
implements Level {
    private static final class_3230 GAIA_TICKET_TYPE = new class_3230(0L, false, class_3230.class_10558.field_55601);
    private static final int GAIA_TICKET_LEVEL = class_8563.method_51829((class_2806)class_2806.field_12803);
    private final class_3218 handle;

    protected VanillaLevel(class_3218 handle) {
        this.handle = handle;
    }

    protected class_3218 handle() {
        return this.handle;
    }

    @Override
    public CompletableFuture<Boolean> restoreSnapshot(Snapshot snapshot, int amount) {
        if (amount > 0 && snapshot instanceof GaiaSnapshot) {
            GaiaSnapshot gaiaSnapshot = (GaiaSnapshot)snapshot;
            return this.loadChunkAsync(snapshot.x(), snapshot.z()).thenApply(c -> this.restoreSnapshotNow(gaiaSnapshot, amount));
        }
        return CompletableFuture.completedFuture(false);
    }

    private boolean restoreSnapshotNow(GaiaSnapshot snapshot, int amount) {
        class_3215 chunkSource = this.chunkSource();
        class_2818 levelChunk = chunkSource.method_21730(snapshot.x(), snapshot.z());
        if (levelChunk == null) {
            return false;
        }
        Vector3i offset = ChunkUtil.toChunkSectionPos(snapshot.chunk().region().min());
        int xOffset = offset.blockX();
        int yOffset = offset.blockY();
        int zOffset = offset.blockZ();
        IndexedIterator<class_2680> it = snapshot.iterator();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        int counter = 0;
        while (it.hasNext() && ++counter <= amount) {
            class_2680 result;
            int index = it.index();
            class_2680 toRestore = it.next();
            int y = yOffset + index / 256;
            int z = zOffset + index % 256 / 16;
            int x = xOffset + index % 256 % 16;
            if (!snapshot.chunk().region().contains(x, y, z) || (result = levelChunk.method_12010((class_2338)mutablePos.method_10103(x, y, z), toRestore, 512)) == null || result == toRestore) continue;
            chunkSource.method_14128((class_2338)mutablePos);
        }
        return it.hasNext();
    }

    @Override
    public CompletableFuture<Snapshot> snapshot(ChunkRegion chunk) {
        return this.loadChunkAsync(chunk.x(), chunk.z()).thenApply(c -> VanillaSnapshot.from(chunk, c));
    }

    @Override
    public CompletableFuture<?> loadChunkWithTicket(int x, int z) {
        return this.loadChunkAsync(x, z).thenAccept(c -> this.addChunkTicket(x, z));
    }

    protected CompletableFuture<class_2791> loadChunkAsync(int x, int z) {
        return this.chunkSource().method_17299(x, z, class_2806.field_12795, false).thenApply(result -> (class_2791)result.method_57132(IllegalStateException::new));
    }

    @Override
    public void addChunkTicket(int x, int z) {
        class_1923 chunkPos = new class_1923(x, z);
        this.chunkSource().method_66008(this.gaiaTicket(), chunkPos);
    }

    protected class_3228 gaiaTicket() {
        return new class_3228(GAIA_TICKET_TYPE, GAIA_TICKET_LEVEL);
    }

    protected class_3215 chunkSource() {
        return this.handle().method_14178();
    }
}

