/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.platform.codec;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.moros.gaia.api.util.supplier.Suppliers;
import me.moros.gaia.common.platform.codec.SimpleCodec;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3551;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BlockStateCodec
implements SimpleCodec<class_2680> {
    static final SimpleCodec<class_2680> INSTANCE = new BlockStateCodec();
    private final int dataVersion = class_155.method_16673().comp_4026().comp_4038();
    private final Logger logger = LoggerFactory.getLogger((String)"Gaia");
    private final Supplier<Map<String, class_2680>> cache = Suppliers.lazy(BlockStateCodec::buildCache);

    private BlockStateCodec() {
    }

    @Override
    public int dataVersion() {
        return this.dataVersion;
    }

    @Override
    public String toString(class_2680 value) {
        return BlockStateCodec.convertToString(value);
    }

    @Override
    public @Nullable class_2680 fromString(String raw, int srcVersion) {
        class_2680 result = this.cache.get().computeIfAbsent(raw, v -> this.calculateBlockState((String)v, srcVersion));
        if (result == null) {
            this.logger.warn("Invalid BlockState: " + raw + ". Block will be replaced with air.");
            return class_2246.field_10124.method_9564();
        }
        return result;
    }

    private @Nullable class_2680 calculateBlockState(String data, int srcVersion) {
        class_2487 nbt = this.stateToNBT(data);
        class_2487 result = (class_2487)class_3551.method_15450().update(class_1208.field_5720, new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt), srcVersion, this.dataVersion).getValue();
        return this.nbtToState(result);
    }

    private class_2487 stateToNBT(String blockState) {
        int propIdx = blockState.indexOf(91);
        class_2487 tag = new class_2487();
        if (propIdx < 0) {
            tag.method_10582("Name", blockState);
        } else {
            String[] propArr;
            tag.method_10582("Name", blockState.substring(0, propIdx));
            class_2487 propTag = new class_2487();
            String props = blockState.substring(propIdx + 1, blockState.length() - 1);
            for (String pair : propArr = props.split(",")) {
                String[] split = pair.split("=");
                propTag.method_10582(split[0], split[1]);
            }
            tag.method_10566("Properties", (class_2520)propTag);
        }
        return tag;
    }

    private @Nullable class_2680 nbtToState(class_2487 nbt) {
        class_2248 block;
        if (!nbt.method_10545("Name")) {
            return null;
        }
        class_2960 rsl = nbt.method_10558("Name").map(class_2960::method_12829).orElse(null);
        class_2248 class_22482 = block = rsl == null ? null : (class_2248)class_7923.field_41175.method_29107(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)rsl));
        if (block == null) {
            return null;
        }
        class_2680 blockState = block.method_9564();
        class_2487 compoundTag = nbt.method_10562("Properties").orElse(null);
        if (compoundTag != null) {
            class_2689 stateDefinition = block.method_9595();
            for (String propertyName : compoundTag.method_10541()) {
                class_2769 property = stateDefinition.method_11663(propertyName);
                if (property == null) continue;
                blockState = BlockStateCodec.trySetValue(blockState, property, propertyName, compoundTag);
            }
        }
        return blockState;
    }

    private static <T extends Comparable<T>> class_2680 trySetValue(class_2680 state, class_2769<T> property, String propertyName, class_2487 compoundTag) {
        return compoundTag.method_10558(propertyName).flatMap(arg_0 -> property.method_11900(arg_0)).map(t -> (class_2680)state.method_11657(property, t)).orElse(state);
    }

    private static String propertyMapper(Map.Entry<class_2769<?>, Comparable<?>> entry) {
        class_2769<?> property = entry.getKey();
        return property.method_11899() + "=" + BlockStateCodec.getName(property, entry.getValue());
    }

    private static <T extends Comparable<T>> String getName(class_2769<T> property, Comparable<?> value) {
        return property.method_11901(value);
    }

    private static String convertToString(class_2680 state) {
        StringBuilder sb = new StringBuilder();
        sb.append(class_7923.field_41175.method_10221((Object)state.method_26204()));
        if (!state.method_11656().isEmpty()) {
            sb.append('[');
            sb.append(state.method_11656().entrySet().stream().map(BlockStateCodec::propertyMapper).collect(Collectors.joining(",")));
            sb.append(']');
        }
        return sb.toString();
    }

    private static Map<String, class_2680> buildCache() {
        ConcurrentHashMap<String, class_2680> map = new ConcurrentHashMap<String, class_2680>(class_2248.field_10651.method_10204());
        class_2248.field_10651.forEach(state -> map.put(BlockStateCodec.convertToString(state), (class_2680)state));
        return map;
    }
}

