/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.service;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.session.SessionOwner;
import java.util.Optional;
import me.moros.gaia.api.arena.region.Region;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.api.service.SelectionService;
import me.moros.math.Vector3i;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class WorldEditSelectionService
implements SelectionService {
    @Override
    public void resetSelection(GaiaUser user) {
    }

    @Override
    public Optional<Region> selection(GaiaUser user) {
        LocalSession session;
        Player player = this.adapt(user);
        if (player != null && (session = WorldEdit.getInstance().getSessionManager().getIfPresent((SessionOwner)player)) != null) {
            try {
                com.sk89q.worldedit.regions.Region selectedRegion = session.getSelection(player.getWorld());
                if (selectedRegion instanceof CuboidRegion) {
                    CuboidRegion cr = (CuboidRegion)selectedRegion;
                    Vector3i min = Vector3i.of(cr.getMinimumPoint().x(), cr.getMinimumPoint().y(), cr.getMinimumPoint().z());
                    Vector3i max = Vector3i.of(cr.getMaximumPoint().x(), cr.getMaximumPoint().y(), cr.getMaximumPoint().z());
                    return Optional.of(Region.of(min, max));
                }
            }
            catch (IncompleteRegionException incompleteRegionException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    protected abstract @Nullable Player adapt(GaiaUser var1);
}

