/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.storage;

import gaia.libraries.linbus.stream.LinBinaryIO;
import gaia.libraries.linbus.tree.LinCompoundTag;
import gaia.libraries.linbus.tree.LinRootEntry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import me.moros.gaia.api.chunk.Snapshot;
import me.moros.gaia.api.util.ChunkUtil;
import me.moros.gaia.common.platform.codec.Codecs;

public class SchemWriter
implements Closeable {
    private static final int CURRENT_VERSION = 3;
    private final DataOutputStream outputStream;

    public SchemWriter(DataOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void write(Snapshot snapshot) throws IOException {
        LinRootEntry rootEntry = new LinRootEntry("", LinCompoundTag.builder().put("Schematic", this.asTag(snapshot)).build());
        LinBinaryIO.write(this.outputStream, rootEntry);
    }

    private LinCompoundTag asTag(Snapshot snapshot) {
        int width = snapshot.width();
        int height = snapshot.height();
        int length = snapshot.length();
        LinCompoundTag.Builder schematic = LinCompoundTag.builder();
        schematic.putInt("Version", 3);
        schematic.putInt("DataVersion", Codecs.blockStateCodec().dataVersion());
        LinCompoundTag.Builder metadata = LinCompoundTag.builder();
        metadata.putString("Author", "Gaia");
        metadata.putLong("Date", System.currentTimeMillis());
        schematic.put("Metadata", metadata.build());
        schematic.putShort("Width", (short)width);
        schematic.putShort("Height", (short)height);
        schematic.putShort("Length", (short)length);
        schematic.putIntArray("Offset", ChunkUtil.toChunkSectionPos(snapshot.chunk().region().min()).toIntArray());
        schematic.put("Blocks", this.encodeBlocks(snapshot, width, height, length));
        return schematic.build();
    }

    private LinCompoundTag encodeBlocks(Snapshot snapshot, int width, int height, int length) {
        PaletteMap paletteMap = new PaletteMap();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(width * height * length);
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int x = 0; x < width; ++x) {
                    String key = snapshot.getStateString(x, y, z);
                    int id = paletteMap.getId(key);
                    while ((id & 0xFFFFFF80) != 0) {
                        buffer.write(id & 0x7F | 0x80);
                        id >>>= 7;
                    }
                    buffer.write(id);
                }
            }
        }
        return LinCompoundTag.builder().put("Palette", paletteMap.toNbt()).putByteArray("Data", buffer.toByteArray()).build();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    private static final class PaletteMap {
        private final Object2IntMap<String> contents = new Object2IntOpenHashMap();
        private int nextId;

        private PaletteMap() {
            this.contents.defaultReturnValue(-1);
            this.nextId = 0;
        }

        public int getId(String key) {
            return this.contents.computeIfAbsent((Object)key, s -> ++this.nextId);
        }

        public LinCompoundTag toNbt() {
            LinCompoundTag.Builder result = LinCompoundTag.builder();
            Object2IntMaps.fastForEach(this.contents, e -> result.putInt((String)e.getKey(), e.getIntValue()));
            return result.build();
        }
    }
}

