/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.common.storage.serializer;

import java.lang.reflect.Type;
import me.moros.gaia.api.util.ChunkUtil;
import me.moros.math.Vector3i;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class Vector3iSerializer
implements TypeSerializer<Vector3i> {
    static final Vector3iSerializer INSTANCE = new Vector3iSerializer();

    private Vector3iSerializer() {
    }

    public Vector3i deserialize(Type type, ConfigurationNode source) throws SerializationException {
        int[] array = (int[])source.get(int[].class, (Object)new int[0]);
        if (array.length != 3) {
            throw new SerializationException("Invalid Vector: Expected array length 3");
        }
        Vector3i result = Vector3i.from(array);
        if (!ChunkUtil.isValidPosition(result)) {
            throw new SerializationException("Invalid Vector %s exceeds bounds!".formatted(result));
        }
        return result;
    }

    public void serialize(Type type, @Nullable Vector3i vector, ConfigurationNode target) throws SerializationException {
        if (vector == null) {
            target.raw(null);
            return;
        }
        target.set((Object)vector.toIntArray());
    }
}

