/*
 * Decompiled with CFR 0.152.
 */
package me.moros.gaia.fabric;

import java.nio.file.Path;
import me.moros.gaia.api.platform.GaiaUser;
import me.moros.gaia.api.service.LevelService;
import me.moros.gaia.api.service.SelectionService;
import me.moros.gaia.api.service.UserService;
import me.moros.gaia.api.util.PluginInfo;
import me.moros.gaia.common.AbstractGaia;
import me.moros.gaia.common.command.Commander;
import me.moros.gaia.common.util.PluginInfoContainer;
import me.moros.gaia.fabric.platform.FabricGaiaUser;
import me.moros.gaia.fabric.service.FabricWorldEditSelectionService;
import me.moros.gaia.fabric.service.GaiaSelectionService;
import me.moros.gaia.fabric.service.LevelServiceImpl;
import me.moros.gaia.fabric.service.UserServiceImpl;
import me.moros.tasker.executor.SyncExecutor;
import me.moros.tasker.fabric.FabricExecutor;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.fabric.FabricServerCommandManager;
import org.slf4j.LoggerFactory;

public class FabricGaia
extends AbstractGaia<ModContainer> {
    private final Commander commander;

    FabricGaia(ModContainer container, Path path) {
        super(container, path, LoggerFactory.getLogger((String)container.getMetadata().getName()));
        this.registerLifecycleListeners();
        FabricServerCommandManager manager = new FabricServerCommandManager(ExecutionCoordinator.simpleCoordinator(), SenderMapper.create(s -> FabricGaiaUser.from(this.api(), s), s -> (class_2168)((FabricGaiaUser)s).handle()));
        this.commander = Commander.create((CommandManager<GaiaUser>)manager, this.api(), this.logger());
    }

    private void registerLifecycleListeners() {
        ServerLifecycleEvents.SERVER_STARTED.register(this::onEnable);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onDisable);
    }

    private void onEnable(MinecraftServer server) {
        this.factory.bind(PluginInfo.class, this::createInfo).bind(SyncExecutor.class, FabricExecutor::new).bind(UserService.class, () -> new UserServiceImpl(() -> this.api(), server.method_3760())).bind(LevelService.class, () -> new LevelServiceImpl(this.logger(), server));
        this.bindSelectionService(server);
        this.load();
    }

    private void onDisable(MinecraftServer server) {
        this.disable();
    }

    private void bindSelectionService(MinecraftServer server) {
        if (FabricLoader.getInstance().isModLoaded("worldedit")) {
            this.factory.bind(SelectionService.class, () -> new FabricWorldEditSelectionService(server));
        } else {
            this.factory.bind(SelectionService.class, GaiaSelectionService::new);
        }
    }

    private PluginInfo createInfo() {
        return new PluginInfoContainer(((ModContainer)this.parent).getMetadata().getAuthors().stream().map(Person::getName).findFirst().orElse("Moros"), ((ModContainer)this.parent).getMetadata().getVersion().getFriendlyString());
    }
}

